/*
 * Decompiled with CFR 0.152.
 */
package ordermate.dbconnection.metadata.sanityCheck;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import ordermate.OrderMate;
import ordermate.database.DBConnectionInterface;
import ordermate.dbconnection.metadata.MetaDataHelper;
import ordermate.dbconnection.metadata.sanityCheck.AbstractSanityCheckCommand;
import ordermate.signals.Signal;

public class CheckFkReferences
extends AbstractSanityCheckCommand {
    private MetaDataHelper database;
    private final String msgPrefix = "Checking FK references ";

    public CheckFkReferences(MetaDataHelper newDatabase, Signal updateSignal) {
        super(updateSignal);
        this.database = newDatabase;
    }

    @Override
    public boolean execute() throws SQLException {
        boolean returnVal = true;
        this.sendStatusUpdateMsg("Checking FK references ");
        Iterator<String> tablesIt = this.database.getAllTables().iterator();
        while (tablesIt.hasNext()) {
            String currentTable = tablesIt.next().toString();
            this.sendStatusUpdateMsg("Checking FK references  for " + currentTable);
            returnVal &= this.checkFKReferencesForTable(currentTable);
        }
        return returnVal;
    }

    private boolean checkFKReferencesForTable(String currentTable) throws SQLException {
        boolean returnVal = true;
        Iterator<String> columnsIt = this.database.getColumns(currentTable).iterator();
        while (columnsIt.hasNext()) {
            String currentColumn = columnsIt.next().toString();
            if (!this.database.isFKColumn(currentColumn)) continue;
            String selectFKReferences = this.getHangingFKReferencesSelectStmt(currentTable, currentColumn);
            try {
                DBConnectionInterface dc = this.database.getDatabaseConnection();
                ResultSet rs = dc.executeQuery(selectFKReferences);
                HashSet<Integer> hangingRefs = new HashSet<Integer>();
                while (rs.next()) {
                    hangingRefs.add(new Integer(rs.getInt(1)));
                }
                dc.release(rs);
                returnVal &= this.dealWithErrors(currentTable, currentColumn, hangingRefs);
            }
            catch (SQLException e) {
                OrderMate.LOG.error("Error checking table " + currentTable, (Throwable)e);
                this.addError("SQL error while checking " + currentTable + " : " + e.getMessage());
            }
        }
        return returnVal;
    }

    private String getHangingFKReferencesSelectStmt(String table, String fkColumn) {
        String referencedTable = this.database.getFKColumnTableRefence(fkColumn);
        String query = " SELECT t1." + fkColumn + " FROM " + table + " AS t1  LEFT JOIN " + referencedTable + " AS t2    ON t1." + fkColumn + " = t2.ID  WHERE t2.ID IS NULL and t1." + fkColumn + " != 0 ";
        return query;
    }

    private boolean dealWithErrors(String table, String fkColumn, Collection errors) {
        if (errors.size() == 0) {
            return true;
        }
        String fkRefs = "";
        Iterator it = errors.iterator();
        while (it.hasNext()) {
            fkRefs = fkRefs + it.next().toString();
            if (!it.hasNext()) continue;
            fkRefs = fkRefs + " , ";
        }
        String error = fkColumn + " in " + table + " has hanging FK references for values " + fkRefs;
        this.getErrorList().add(error);
        return false;
    }
}

