/*
 * Decompiled with CFR 0.152.
 */
package ordermate.deployer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.misc.application.Application;
import ordermate.deployer.TerminalDeployment;

class DeployerModel
extends AbstractTableModel {
    private final int NON_EDITS = 2;
    private final String[] COLUMNS;
    private List<Application> deployables = new ArrayList<Application>();
    private List<TerminalDeployment> allTerminals;

    DeployerModel() {
        this.deployables.add(Application.Servermate);
        this.deployables.add(Application.Officemate);
        this.deployables.add(Application.Waitermate);
        this.deployables.add(Application.TouchPrepXPress);
        this.COLUMNS = new String[3 + this.deployables.size()];
        this.COLUMNS[0] = "Name";
        this.COLUMNS[1] = "IP";
        this.COLUMNS[2] = "Deploy?";
        for (int i = 0; i < this.deployables.size(); ++i) {
            this.COLUMNS[3 + i] = this.deployables.get(i).toString();
        }
    }

    List<TerminalDeployment> getDeploys() {
        return Collections.unmodifiableList(this.allTerminals);
    }

    public void setTerminals(List<Terminal> terminals) {
        this.allTerminals = new ArrayList<TerminalDeployment>();
        for (Terminal terminal : terminals) {
            String type;
            String ip = terminal.getIPAddress();
            TerminalDeployment deploy = this.findByIp(ip);
            if (deploy == null) {
                deploy = new TerminalDeployment(terminal.getIPAddress(), terminal.getLabel());
                deploy.deploys.add(Application.Officemate);
                this.allTerminals.add(deploy);
            }
            if ("ServerMate".equals(type = terminal.getTerminalType())) {
                deploy.deploys.add(Application.Servermate);
                continue;
            }
            if (!"WaiterMate".equals(type)) continue;
            deploy.deploys.add(Application.Waitermate);
        }
    }

    private TerminalDeployment findByIp(String ip) {
        for (TerminalDeployment deploy : this.allTerminals) {
            if (!ip.equals(deploy.ip)) continue;
            return deploy;
        }
        return null;
    }

    public void setTpxs(List<KTSDocketPrinter> printers) {
        for (KTSDocketPrinter printer : printers) {
            String ip = printer.getIpAddress();
            TerminalDeployment deploy = this.findByIp(ip);
            if (deploy == null) {
                deploy = new TerminalDeployment(ip, printer.getLabel());
                this.allTerminals.add(deploy);
            }
            deploy.deploys.add(Application.TouchPrepXPress);
        }
    }

    @Override
    public int getRowCount() {
        return this.allTerminals.size();
    }

    @Override
    public int getColumnCount() {
        return this.COLUMNS.length;
    }

    @Override
    public String getColumnName(int index) {
        return this.COLUMNS[index];
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TerminalDeployment deploy = this.allTerminals.get(row);
        if (col >= 2) {
            if (col == 2) {
                deploy.willDeploy = !deploy.willDeploy;
            } else {
                Application app = this.deployables.get(col - 2 - 1);
                if (((Boolean)value).booleanValue()) {
                    deploy.deploys.add(app);
                } else {
                    deploy.deploys.remove((Object)app);
                }
            }
        }
        this.fireTableCellUpdated(row, col);
    }

    @Override
    public Class<?> getColumnClass(int index) {
        if (index >= 2) {
            return Boolean.class;
        }
        return super.getColumnClass(index);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col >= 2;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TerminalDeployment deploy = this.allTerminals.get(rowIndex);
        if (columnIndex == 0) {
            return deploy.name;
        }
        if (columnIndex == 1) {
            return deploy.ip;
        }
        if (columnIndex == 2) {
            return deploy.willDeploy;
        }
        return deploy.deploys.contains((Object)this.deployables.get(columnIndex - 2 - 1));
    }
}

