/*
 * Decompiled with CFR 0.152.
 */
package ordermate.deployer;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import ordermate.OrderMate;
import ordermate.database.failover.FailoverSetup;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.misc.application.Application;
import ordermate.deployer.DeployerModel;
import ordermate.deployer.OrderMateDeployerDialog;
import ordermate.deployer.RemoteFileCopy;
import ordermate.deployer.TerminalDeployment;
import ordermate.gui.dialogs.ProgressDialog;
import ordermate.launcher.LauncherConfig;

public class OrderMateLauncherDeployer {
    private static OrderMateLauncherDeployer deployer;
    private DeployerModel model;
    private OrderMateDeployerDialog deployerDialog;

    public static final OrderMateLauncherDeployer getInstance() {
        if (deployer == null) {
            deployer = new OrderMateLauncherDeployer();
        }
        return deployer;
    }

    private OrderMateLauncherDeployer() {
    }

    public void showDeployDialog() {
        if (this.deployerDialog != null) {
            this.deployerDialog.setVisible(false);
        }
        if (this.model == null) {
            this.model = new DeployerModel();
        }
        this.model.setTerminals(this.getTerminals());
        this.model.setTpxs(this.getPrinters());
        this.deployerDialog = new OrderMateDeployerDialog(this, this.model);
        this.deployerDialog.setVisible(true);
    }

    void doDeploy() {
        List<TerminalDeployment> deploys = this.model.getDeploys();
        ArrayList<TerminalDeployment> willDeploy = new ArrayList<TerminalDeployment>();
        for (TerminalDeployment deploy : deploys) {
            if (!deploy.willDeploy) continue;
            willDeploy.add(deploy);
        }
        ArrayList<String> allServers = new ArrayList<String>();
        for (FailoverSetup nextSetup : PersistenceManager.getObjectList(FailoverSetup.class, Query.select(FailoverSetup.class).active(FailoverSetup.class).orderBy(FailoverSetup.Properties.SLAVE).orderBy(FailoverSetup.Properties.SEQUENCE).toString())) {
            allServers.add(nextSetup.getTerminal().getIPAddress());
        }
        DeployTask task = new DeployTask(willDeploy, allServers);
        ProgressDialog dialog = new ProgressDialog((Frame)this.deployerDialog, true, task);
        dialog.start();
        Map successMap = task.successMap;
        StringBuilder SB = new StringBuilder("<html>Deployment Status:<ol>");
        for (TerminalDeployment deployment : willDeploy) {
            SB.append("<li>").append(deployment.ip).append(" ").append(deployment.name).append(" = ").append(successMap.get(deployment)).append("</li>");
        }
        SB.append("</ol></html>");
        JOptionPane.showMessageDialog(this.deployerDialog, SB.toString());
    }

    private boolean deploy(TerminalDeployment deploy, List<String> allServers) {
        OrderMate.LOG.info("Searching for OMLauncher.jar");
        File jarFile = new File("OMLauncher.jar");
        if (!jarFile.exists()) {
            OrderMate.LOG.info("Couldn't find it, searching under webstart.");
            jarFile = new File("//localhost/webstart/OMLauncher.jar");
            if (!jarFile.exists()) {
                OrderMate.LOG.info("No OMLauncher available, not even at //localhost/webstart/");
                return false;
            }
        }
        File configFile = new File("C:/temp/Launcher.cfg");
        configFile.deleteOnExit();
        this.createConfig(allServers, deploy.deploys, configFile);
        return this.copyOverFiles(deploy.ip, configFile, jarFile);
    }

    private boolean copyOverFiles(String ip, File config, File jar) {
        InetAddress add = null;
        try {
            add = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (add != null && ip.equals(add.getHostAddress()) || ip.equals("localhost") || ip.equals("127.0.0.1")) {
            return this.deployLocal(config, jar);
        }
        return this.deployRemote(ip, config, jar);
    }

    private boolean deployLocal(File config, File jar) {
        boolean fine = false;
        File dir = new File("C:/Program Files/OrderMate/OrderMateTemp/");
        if (!dir.exists()) {
            dir = new File("C:/Program Files (x86)/OrderMate/OrderMateTemp/");
        }
        OrderMate.LOG.info("Copying over files to " + dir);
        fine = this.localCopy(config, new File(dir + File.separator + config.getName()));
        if (fine) {
            fine = this.localCopy(jar, new File(dir + File.separator + jar.getName()));
            OrderMate.LOG.info("Copied local launcher files:");
        } else {
            OrderMate.LOG.info("No good, can't copy local files.");
        }
        return fine;
    }

    private boolean deployRemote(String ip, File config, File jar) {
        OrderMate.LOG.info("Copying over files to /c$/Program Files/OrderMate/OrderMateTemp");
        boolean fine = false;
        fine = this.copyTo(ip + "/c$/Program Files/OrderMate/OrderMateTemp/", config, jar);
        if (!fine) {
            OrderMate.LOG.info("No good. Attempting to copy over files to /c$/Program Files (x86)/OrderMate/OrderMateTemp");
            fine = this.copyTo(ip + "/c$/Program Files (x86)/OrderMate/OrderMateTemp/", config, jar);
        }
        return fine;
    }

    private boolean copyTo(String remotePath, File config, File jar) {
        boolean fine;
        String remoteConfig = remotePath + config.getName();
        String remoteJar = remotePath + jar.getName();
        RemoteFileCopy copy = RemoteFileCopy.makeDefaultVersion();
        boolean bl = fine = copy.copyFile(config.getAbsolutePath(), remoteConfig) && copy.copyFile(jar.getAbsolutePath(), remoteJar);
        if (!fine) {
            copy = RemoteFileCopy.makeServerVersion();
            fine = copy.copyFile(config.getAbsolutePath(), remoteConfig) && copy.copyFile(jar.getAbsolutePath(), remoteJar);
        }
        return fine;
    }

    private boolean localCopy(File thisFile, File thatFile) {
        byte[] bytes = new byte[2048];
        try {
            FileInputStream reader = new FileInputStream(thisFile);
            FileOutputStream writer = new FileOutputStream(thatFile);
            int length = 0;
            while ((length = reader.read(bytes)) > 0) {
                writer.write(bytes, 0, length);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException ex) {
            OrderMate.LOG.error("Cannot read/write omlauncher files", (Throwable)ex);
            return false;
        }
        return true;
    }

    void createConfig(List<String> allServers, Collection<Application> deploys, File file) {
        ArrayList<Application> allDeploys = new ArrayList<Application>(deploys);
        LauncherConfig config = new LauncherConfig(allDeploys, allServers);
        config.writeToDisk(file);
    }

    private List<Terminal> getTerminals() {
        return PersistenceManager.getObjectList(Terminal.class, Query.select(Terminal.class).active(Terminal.class).toString(), null);
    }

    private List<KTSDocketPrinter> getPrinters() {
        return PersistenceManager.getObjectList(KTSDocketPrinter.class, Query.select(KTSDocketPrinter.class).active(KTSDocketPrinter.class).toString(), null);
    }

    class DeployTask
    extends AbstractTask {
        private TerminalDeployment current;
        private List<TerminalDeployment> deployments;
        private List<String> allServers;
        private Map<TerminalDeployment, Boolean> successMap = new LinkedHashMap<TerminalDeployment, Boolean>();

        DeployTask(List<TerminalDeployment> deployments, List<String> allServers) {
            this.deployments = deployments;
            this.allServers = allServers;
        }

        @Override
        protected int getTotalSubTasks() {
            return this.deployments.size();
        }

        @Override
        public String getName() {
            if (this.current == null) {
                return "Deploying OMLauncher";
            }
            return "Deploying to:" + this.current.ip;
        }

        @Override
        protected void performTask() throws Exception {
            Iterator<TerminalDeployment> iterator = this.deployments.iterator();
            while (iterator.hasNext()) {
                TerminalDeployment deployment;
                this.current = deployment = iterator.next();
                this.successMap.put(deployment, OrderMateLauncherDeployer.this.deploy(deployment, this.allServers));
                this.emitProgress();
            }
        }
    }
}

