/*
 * Decompiled with CFR 0.152.
 */
package ordermate.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;
import ordermate.OrderMate;

public class RemoteFileCopy {
    private static final int TIMEOUT = 1000;
    private final String user;
    private final String password;
    private final String domain;

    public static RemoteFileCopy makeDefaultVersion() {
        return new RemoteFileCopy("ORDERMATE", "administrator", "posman12");
    }

    public static RemoteFileCopy makeServerVersion() {
        return new RemoteFileCopy("ORDERMATE", "administrator", "Posman12");
    }

    public RemoteFileCopy(String theDomain, String theUser, String thePassword) {
        this.user = theUser;
        this.password = thePassword;
        this.domain = theDomain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copyFile(String theLocalFile, String theRemoteFile) {
        File file = new File(theLocalFile);
        int length = 0;
        byte[] bytes = new byte[2048];
        SmbFile remoteFile = null;
        FileInputStream fin = null;
        OutputStream out = null;
        boolean fine = true;
        try {
            NtlmPasswordAuthentication authentication = new NtlmPasswordAuthentication(this.domain, this.user, this.password);
            remoteFile = new SmbFile("smb://" + theRemoteFile, authentication);
            remoteFile.setConnectTimeout(1000);
            remoteFile.setReadTimeout(1000);
            remoteFile.connect();
            out = remoteFile.getOutputStream();
            fin = new FileInputStream(file);
            while ((length = fin.read(bytes)) > 0) {
                out.write(bytes, 0, length);
            }
        }
        catch (IOException ex) {
            OrderMate.LOG.warn("Cannot write to file :" + remoteFile, (Throwable)ex);
            fine = false;
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Cannot close off file:", (Throwable)ex);
                }
            }
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    OrderMate.LOG.error("Cannot close off file:", (Throwable)ex);
                }
            }
        }
        return fine;
    }
}

