/*
 * Decompiled with CFR 0.152.
 */
package ordermate.diff;

import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.diff.BusinessExportMapping;
import ordermate.diff.BusinessExportMappingBuilder;
import ordermate.diff.BusinessExportRefMapping;

public class BOExportMappingContainer {
    private Map<PropertyAccessor, BusinessExportMapping> propAccessorMap;
    private Map<PropertiedObject.Property, List<PropertyAccessor>> propAccessorLinksMap;
    protected Map<Class, List<BusinessExportMapping>> classPropsMap = new HashMap<Class, List<BusinessExportMapping>>();
    protected Map<Class, List<BusinessExportRefMapping>> refMap = new HashMap<Class, List<BusinessExportRefMapping>>();
    protected Map<Class, List<BusinessExportMapping>> classLinkPropsMap = new HashMap<Class, List<BusinessExportMapping>>();
    private boolean strict;

    public BOExportMappingContainer(boolean strict) {
        this.strict = strict;
        this.propAccessorMap = new HashMap<PropertyAccessor, BusinessExportMapping>();
        this.propAccessorLinksMap = new HashMap<PropertiedObject.Property, List<PropertyAccessor>>();
    }

    public void addMappingBuilders(BusinessExportMappingBuilder ... mappers) {
        for (BusinessExportMappingBuilder mapper : mappers) {
            if (this.strict && !mapper.getUnmappedFields().isEmpty()) {
                this.strictValidation(mapper);
            }
            Collection<BusinessExportMapping> mappings = mapper.getMappings();
            for (BusinessExportMapping nextMapping : mappings) {
                if (nextMapping.isExportable()) {
                    this.propAccessorMap.put(nextMapping.getBusinessPropertyAccessor(), nextMapping);
                    this.addToPropAccessorLinks(nextMapping);
                    this.addToClassPropsMap(nextMapping);
                }
                if (nextMapping.isLinkage()) {
                    this.addToLinkageMap(nextMapping);
                    continue;
                }
                if (!(nextMapping instanceof BusinessExportRefMapping)) continue;
                this.addToRefMap((BusinessExportRefMapping)nextMapping);
            }
        }
    }

    private void addToPropAccessorLinks(BusinessExportMapping exportMapping) {
        List<Object> propertyAccessorList = new ArrayList();
        if (this.propAccessorLinksMap.get(exportMapping.getBusinessPropertyAccessor().getBaseProperty()) != null) {
            propertyAccessorList = this.propAccessorLinksMap.get(exportMapping.getBusinessPropertyAccessor().getBaseProperty());
            propertyAccessorList.add(exportMapping.getBusinessPropertyAccessor());
        } else {
            propertyAccessorList.add(exportMapping.getBusinessPropertyAccessor());
        }
        this.propAccessorLinksMap.put(exportMapping.getBusinessPropertyAccessor().getBaseProperty(), propertyAccessorList);
    }

    protected void strictValidation(BusinessExportMappingBuilder mapper) {
        Set<Field> untouched = mapper.getUnmappedFields();
        StringBuilder SB = new StringBuilder("Strict validation on Export Mapping failed for " + mapper.getExportClass() + "\r\n\r\nUnmapped export fields:\r\n");
        int count = 5;
        for (Field nextField : untouched) {
            SB.append(nextField.getType()).append(" ").append(nextField.getName()).append("\r\n");
            if (--count != 0) continue;
            break;
        }
        throw new IllegalStateException(SB.toString());
    }

    public List<BusinessExportMapping> getMappings(PropertyAccessor propertyAccessor) {
        ArrayList<BusinessExportMapping> exportMappings = new ArrayList<BusinessExportMapping>();
        List<PropertyAccessor> propertyAccessorList = this.propAccessorLinksMap.get(propertyAccessor);
        if (propertyAccessorList != null) {
            for (PropertyAccessor currentPropAccessor : propertyAccessorList) {
                if (this.propAccessorMap.get(currentPropAccessor) == null) continue;
                exportMappings.add(this.propAccessorMap.get(currentPropAccessor));
            }
        }
        return exportMappings;
    }

    public Collection<BusinessExportMapping> getAllMappings() {
        return this.propAccessorMap.values();
    }

    public Map<PropertyAccessor, BusinessExportMapping> getPropAccessorMap() {
        return this.propAccessorMap;
    }

    public Map<Class, List<BusinessExportMapping>> getClassPropsMap() {
        return this.classPropsMap;
    }

    public Map<Class, List<BusinessExportRefMapping>> getRefMap() {
        return this.refMap;
    }

    public Map<Class, List<BusinessExportMapping>> getClassLinkPropsMap() {
        return this.classLinkPropsMap;
    }

    private <T> List<T> getExportMappingsByClass(Class clazz, Map<Class, List<T>> map) {
        List<T> mappedProps = map.get(clazz);
        List<T> superClassProps = map.get(clazz.getSuperclass());
        if (mappedProps != null) {
            if (superClassProps != null) {
                mappedProps.addAll(superClassProps);
            }
            return mappedProps;
        }
        return superClassProps;
    }

    public List<BusinessExportMapping> getPropMappingsByClass(Class clazz) {
        return this.getExportMappingsByClass(clazz, this.classPropsMap);
    }

    public List<BusinessExportRefMapping> getRefMappingsByClass(Class clazz) {
        return this.getExportMappingsByClass(clazz, this.refMap);
    }

    public List<BusinessExportMapping> getLinkPropsMapByClass(Class clazz) {
        return this.getExportMappingsByClass(clazz, this.classLinkPropsMap);
    }

    private void addToRefMap(BusinessExportRefMapping propRefMapping) {
        Class<PropertiedObject> key = propRefMapping.getRefPropertyAccessor().getBaseProperty().getOwner();
        if (this.refMap.containsKey(key)) {
            this.refMap.get(key).add(propRefMapping);
        } else {
            ArrayList<BusinessExportRefMapping> propRefMapList = new ArrayList<BusinessExportRefMapping>();
            propRefMapList.add(propRefMapping);
            this.refMap.put(key, propRefMapList);
        }
    }

    private void addToLinkageMap(BusinessExportMapping linkPropMapping) {
        Class<PropertiedObject> key = linkPropMapping.getBusinessPropertyAccessor().getBaseProperty().getOwner();
        if (this.classLinkPropsMap.containsKey(key)) {
            this.classLinkPropsMap.get(key).add(linkPropMapping);
        } else {
            ArrayList<BusinessExportMapping> propLinkMapList = new ArrayList<BusinessExportMapping>();
            propLinkMapList.add(linkPropMapping);
            this.classLinkPropsMap.put(key, propLinkMapList);
        }
    }

    private void addToClassPropsMap(BusinessExportMapping prop) {
        if (this.classPropsMap.containsKey(prop.getBusinessPropertyAccessor().getBaseProperty().getOwner())) {
            this.classPropsMap.get(prop.getBusinessPropertyAccessor().getBaseProperty().getOwner()).add(prop);
        } else {
            ArrayList<BusinessExportMapping> bOProps = new ArrayList<BusinessExportMapping>();
            bOProps.add(prop);
            this.classPropsMap.put(prop.getBusinessPropertyAccessor().getBaseProperty().getOwner(), bOProps);
        }
    }

    public boolean isRelevantClass(Class clazz) {
        return this.getClassPropsMap().containsKey(clazz) || this.getRefMap().containsKey(clazz) || this.getClassPropsMap().containsKey(clazz.getSuperclass()) || this.getRefMap().containsKey(clazz.getSuperclass()) || this.getClassLinkPropsMap().containsKey(clazz.getSuperclass());
    }

    public boolean isIDMappingExist(Class clazz) {
        PropertiedObject.Property property = PropertiedObject.PropsHelper.getProperties(clazz).getProperty("ID");
        if (this.propAccessorMap.containsKey(property)) {
            return true;
        }
        if (!PersistentDisplayableObject.class.equals(clazz.getSuperclass()) && !PersistentObject.class.equals(clazz.getSuperclass())) {
            PropertiedObject.Property superClassProperty = PropertiedObject.PropsHelper.getProperties(clazz.getSuperclass()).getProperty("ID");
            return this.propAccessorMap.containsKey(superClassProperty);
        }
        return false;
    }
}

