/*
 * Decompiled with CFR 0.152.
 */
package ordermate.diff;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.reflect.FieldUtils;
import au.com.ordermate.util.Stringifier;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import ordermate.OrderMate;
import ordermate.diff.BusinessExportMapping;
import ordermate.diff.DefaultBusinessExportMapping;
import ordermate.diff.DefaultBusinessExportRefMapping;

public class BusinessExportMappingBuilder<E> {
    protected final Class<E> exportClass;
    protected final List<BusinessExportMapping> mappings;
    protected final Set<Field> unmappedFields;
    protected final String xmlAlias;

    public BusinessExportMappingBuilder<E> setExportable(boolean value) {
        if (!this.mappings.isEmpty()) {
            this.mappings.get(this.mappings.size() - 1).setExportable(value);
        }
        return this;
    }

    public BusinessExportMappingBuilder<E> markAsLinkage() {
        if (!this.mappings.isEmpty()) {
            this.mappings.get(this.mappings.size() - 1).markAsLinkage();
        }
        return this;
    }

    public BusinessExportMappingBuilder<E> setStringifier(Stringifier value) {
        if (!this.mappings.isEmpty()) {
            this.mappings.get(this.mappings.size() - 1).setStringifier(value);
        }
        return this;
    }

    public BusinessExportMappingBuilder(Class<E> mainExportClass) {
        this(mainExportClass, null);
    }

    public BusinessExportMappingBuilder(Class<E> mainExportClass, String xmlAlias) {
        this.exportClass = mainExportClass;
        this.mappings = new ArrayList<BusinessExportMapping>();
        this.unmappedFields = new HashSet<Field>();
        this.xmlAlias = xmlAlias;
        this.defineFields(this.exportClass);
    }

    public Class getExportClass() {
        return this.exportClass;
    }

    protected void defineFields(Class clazz) {
        if (Object.class.equals((Object)clazz)) {
            return;
        }
        for (Field field : clazz.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            this.unmappedFields.add(field);
        }
        this.defineFields(clazz.getSuperclass());
    }

    public BusinessExportMappingBuilder<E> autoMap(Class<? extends PropertiedObject> businessClass) {
        PropertiedObject.Props props = null;
        try {
            props = (PropertiedObject.Props)businessClass.getField("Properties").get(null);
        }
        catch (Exception e) {
            OrderMate.LOG.error("Cannot find a Properties on the propertied object");
            return this;
        }
        HashSet<Field> toMap = new HashSet<Field>(this.unmappedFields);
        for (Field field : toMap) {
            BusinessExportMapping idMapping;
            if (Collection.class.isAssignableFrom(field.getType())) continue;
            if (field.getName().equalsIgnoreCase("ID") && (idMapping = this.createAutoIdField(field, props)) != null) {
                this.mappings.add(idMapping);
                this.unmappedFields.remove(field);
                continue;
            }
            boolean found = false;
            for (PropertiedObject.Property property : props.getPropertySet()) {
                if (!property.getName().equalsIgnoreCase(field.getName())) continue;
                this.map((PropertyAccessor)property, field);
            }
            if (found) continue;
        }
        return this;
    }

    protected BusinessExportMapping createAutoIdField(Field field, PropertiedObject.Props props) {
        return new DefaultBusinessExportMapping(props.getProperty("id"), this.exportClass, field, this.xmlAlias);
    }

    public Set<Field> getUnmappedFields() {
        return Collections.unmodifiableSet(this.unmappedFields);
    }

    public BusinessExportMappingBuilder<E> map(PropertyAccessor prop, String fieldName) throws Exception {
        Field field = FieldUtils.getField(this.exportClass, fieldName);
        return this.map(prop, field);
    }

    public BusinessExportMappingBuilder<E> map(PropertyAccessor prop, Field field) {
        return this.map(prop, null, field, null);
    }

    public BusinessExportMappingBuilder<E> mapList(PropertyAccessor listProp, PropertyAccessor refProp, String fieldName) throws Exception {
        return this.map(listProp, refProp, FieldUtils.getField(this.exportClass, fieldName), null);
    }

    public BusinessExportMappingBuilder<E> mapList(PropertyAccessor listProp, PropertyAccessor refProp, String fieldName, boolean exportable) throws Exception {
        return this.map(listProp, refProp, FieldUtils.getField(this.exportClass, fieldName), null);
    }

    public BusinessExportMappingBuilder<E> mapList(PropertyAccessor listProp, PropertyAccessor refProp, String fieldName, Stringifier theStringifier) throws Exception {
        return this.map(listProp, refProp, FieldUtils.getField(this.exportClass, fieldName), theStringifier);
    }

    public BusinessExportMappingBuilder<E> map(PropertyAccessor prop, PropertyAccessor referenceProperty, Field field, Stringifier theStringifier) {
        BusinessExportMapping newMapping = referenceProperty != null ? this.makeReferenceMapping(prop, referenceProperty, field, theStringifier) : this.makeMapping(prop, field);
        this.mappings.add(newMapping);
        this.unmappedFields.remove(field);
        return this;
    }

    public BusinessExportMappingBuilder<E> map(BusinessExportMapping mapping) {
        this.mappings.add(mapping);
        this.unmappedFields.remove(mapping.getExportField());
        return this;
    }

    public BusinessExportMappingBuilder<E> noMap(String ... fieldNames) throws Exception {
        Field[] fields = new Field[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            fields[i] = FieldUtils.getField(this.exportClass, fieldNames[i]);
        }
        return this.noMap(fields);
    }

    public BusinessExportMappingBuilder<E> noMap(Field ... fields) {
        for (Field field : fields) {
            Iterator<BusinessExportMapping> iterator = this.mappings.iterator();
            while (iterator.hasNext()) {
                BusinessExportMapping nextMap = iterator.next();
                if (!field.equals(nextMap.getExportField())) continue;
                iterator.remove();
            }
            this.unmappedFields.remove(field);
        }
        return this;
    }

    public Collection<BusinessExportMapping> getMappings() {
        return this.mappings;
    }

    protected BusinessExportMapping makeMapping(PropertyAccessor property, Field field) {
        return new DefaultBusinessExportMapping(property, this.exportClass, field, this.xmlAlias);
    }

    protected BusinessExportMapping makeReferenceMapping(PropertyAccessor listProperty, PropertyAccessor backwardProperty, Field field, Stringifier theStringifier) {
        if (backwardProperty == null) {
            throw new IllegalArgumentException("Cannot map a list without a backward reference:" + listProperty + " " + field);
        }
        DefaultBusinessExportRefMapping refMapping = new DefaultBusinessExportRefMapping(listProperty, this.exportClass, field, backwardProperty, this.xmlAlias);
        refMapping.setStringifier(theStringifier);
        return refMapping;
    }
}

