/*
 * Decompiled with CFR 0.152.
 */
package ordermate.diff;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentObjectI;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.propertyaccessor.PropertyAccessor;
import au.com.ordermate.util.Stringifier;
import java.lang.reflect.Field;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.diff.BusinessExportMapping;

public class DefaultBusinessExportMapping<B extends PropertiedObject, E>
implements BusinessExportMapping<B, E> {
    protected Stringifier stringy;
    protected final PropertyAccessor propertyAccessor;
    private final Class<E> exportingClass;
    private final Field exportingField;
    protected Stringifier stringifier;
    private String xmlName;
    private String attName;
    private String xmlAlias;
    private boolean exportable;
    private boolean linkage;

    public DefaultBusinessExportMapping(PropertyAccessor accessor, Class<E> exportClazz, Field field) {
        this(accessor, exportClazz, field, null);
    }

    public DefaultBusinessExportMapping(PropertyAccessor accessor, Class<E> exportClazz, Field field, String xmlAlias) {
        this.stringifier = this.stringy = new Stringifier(){

            public String stringify(Object object) {
                if (object instanceof ExportableObject && OnlineIntegrationIDStrategy.MASTER_ID.equals((Object)SystemProperty.getInstance().getOnlineIntegrationIdStrategy())) {
                    if (((ExportableObject)object).getMasterId() != null) {
                        return ((ExportableObject)object).getMasterId().toString();
                    }
                    OrderMate.LOG.warn("Master id is NOT generated for the object, Class type: " + object.getClass() + "ID: " + ((PersistentObject)object).getID());
                    return "0";
                }
                if (object instanceof PersistentObjectI) {
                    return String.valueOf(((PersistentObjectI)object).getID());
                }
                return object == null ? "" : String.valueOf(object);
            }
        };
        this.exportable = true;
        this.linkage = false;
        this.propertyAccessor = accessor;
        this.exportingClass = exportClazz;
        this.exportingField = field;
        this.xmlAlias = xmlAlias;
        this.determineTypeAndAtt();
        if (this.xmlName == null || this.attName == null) {
            throw new IllegalStateException("xmlName or attribute not set:" + this.xmlName + " " + this.attName + " for " + exportClazz + " " + field);
        }
    }

    protected void determineTypeAndAtt() {
        if (this.xmlName == null) {
            XmlType type = this.exportingClass.getAnnotation(XmlType.class);
            if (type != null) {
                this.xmlName = type.name();
            }
            if (this.xmlName == null) {
                this.xmlName = this.exportingClass.getSimpleName();
            }
        }
        if (this.attName == null) {
            XmlElement elementType = this.exportingField.getAnnotation(XmlElement.class);
            if (elementType != null) {
                this.attName = elementType.name();
            } else {
                XmlAttribute attType = this.exportingField.getAnnotation(XmlAttribute.class);
                if (attType != null) {
                    this.attName = attType.name();
                }
            }
        }
        if (this.attName == null || this.attName.equals("null") || this.attName.equals("##default")) {
            this.attName = this.exportingField.getName();
        }
    }

    @Override
    public Class<B> getBusinessClass() {
        return this.propertyAccessor.getBaseProperty().getOwner();
    }

    @Override
    public PropertyAccessor getBusinessPropertyAccessor() {
        return this.propertyAccessor;
    }

    @Override
    public Class<E> getExportClass() {
        return this.exportingClass;
    }

    @Override
    public Field getExportField() {
        return this.exportingField;
    }

    @Override
    public String exportValueToString(B toExport) {
        return this.stringifier.stringify(this.propertyAccessor.resolveValue(toExport));
    }

    @Override
    public String getXmlTypeName() {
        return this.xmlName;
    }

    @Override
    public String getXmlAttributeName() {
        return this.attName;
    }

    @Override
    public String getXmlAlias() {
        return this.xmlAlias;
    }

    @Override
    public void setExportable(boolean value) {
        this.exportable = value;
    }

    @Override
    public boolean isExportable() {
        return this.exportable;
    }

    @Override
    public void markAsLinkage() {
        this.linkage = true;
    }

    @Override
    public boolean isLinkage() {
        return this.linkage;
    }

    @Override
    public void setStringifier(Stringifier value) {
        if (value != null) {
            this.stringifier = value;
        }
    }
}

