/*
 * Decompiled with CFR 0.152.
 */
package ordermate.diff.stringifier;

import au.com.ordermate.util.Stringifier;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.combos.InventoryComboGroupItemUnitLink;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;

public class ComboGroupItemLinkStringifier
implements Stringifier<InventoryComboGroupItemUnitLink> {
    @Override
    public String stringify(InventoryComboGroupItemUnitLink comboGrpItemLink) {
        long displayId = 0L;
        InventoryItemUnit itemUnit = comboGrpItemLink.getItemUnit();
        if (itemUnit != null) {
            displayId = itemUnit.getID();
            if (OnlineIntegrationIDStrategy.MASTER_ID.equals((Object)SystemProperty.getInstance().getOnlineIntegrationIdStrategy())) {
                if (itemUnit.getMasterId() != null) {
                    displayId = itemUnit.getMasterId();
                } else {
                    OrderMate.LOG.warn("Master id is NOT generated for the object, Class type: " + itemUnit.getClass() + "ID: " + itemUnit.getID());
                    displayId = 0L;
                }
            }
        }
        return String.valueOf(displayId);
    }
}

