/*
 * Decompiled with CFR 0.152.
 */
package ordermate.diff.stringifier;

import au.com.ordermate.util.Stringifier;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.combos.InventoryComboGroupSectionLink;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;

public class ComboSectionLinkStringifier
implements Stringifier<InventoryComboGroupSectionLink> {
    @Override
    public String stringify(InventoryComboGroupSectionLink sectionLink) {
        List<InventoryItemUnit> itemUnits;
        StringBuilder comboItemsSB = new StringBuilder();
        InventoryGroup inventoryGroup = sectionLink.getInventoryGroup();
        if (inventoryGroup != null && (itemUnits = inventoryGroup.getItemUnits()) != null) {
            if (OnlineIntegrationIDStrategy.MASTER_ID.equals((Object)SystemProperty.getInstance().getOnlineIntegrationIdStrategy())) {
                this.appendMasterIDs(comboItemsSB, itemUnits);
            } else {
                this.appendIDs(comboItemsSB, itemUnits);
            }
        }
        if (comboItemsSB.length() > 0) {
            comboItemsSB.deleteCharAt(comboItemsSB.length() - 1);
        }
        return comboItemsSB.toString();
    }

    private void appendIDs(StringBuilder sb, List<InventoryItemUnit> itemUnits) {
        for (InventoryItemUnit itemUnit : itemUnits) {
            sb.append(itemUnit.getID()).append(",");
        }
    }

    private void appendMasterIDs(StringBuilder sb, List<InventoryItemUnit> itemUnits) {
        for (InventoryItemUnit itemUnit : itemUnits) {
            if (itemUnit.getMasterId() != null) {
                sb.append(itemUnit.getMasterId()).append(",");
                continue;
            }
            OrderMate.LOG.warn("Master id is NOT generated for the object, Class type: " + itemUnit.getClass() + "ID: " + itemUnit.getID());
        }
    }
}

