/*
 * Decompiled with CFR 0.152.
 */
package ordermate.diff.stringifier;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Stringifier;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryDefaultMod;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryRemove;
import ordermate.database.inventory.Modification;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;

public class InventoryDefaultModStringifier
implements Stringifier<InventoryDefaultMod> {
    @Override
    public String stringify(InventoryDefaultMod defaultMod) {
        long displayId = 0L;
        Modification mod = defaultMod.getDefaultMod();
        if (mod != null) {
            displayId = mod.getID();
            Object obj = this.getDefaultModObj(mod);
            if (obj != null && OnlineIntegrationIDStrategy.MASTER_ID.equals((Object)SystemProperty.getInstance().getOnlineIntegrationIdStrategy())) {
                if (((ExportableObject)obj).getMasterId() != null) {
                    displayId = ((ExportableObject)obj).getMasterId();
                } else {
                    OrderMate.LOG.warn("Master id is NOT generated for the object, Class type: " + mod.getClass() + "ID: " + mod.getID());
                    displayId = 0L;
                }
            }
        }
        return defaultMod.getDiscriminatorValue().concat(" id:").concat(String.valueOf(displayId));
    }

    private Object getDefaultModObj(Modification mod) {
        Modification obj = null;
        if (mod instanceof InventoryOption) {
            obj = PersistenceManager.getByID(mod.getID(), InventoryOption.class);
        } else if (mod instanceof InventoryAdd) {
            obj = PersistenceManager.getByID(mod.getID(), InventoryAdd.class);
        } else if (mod instanceof InventoryRemove) {
            obj = PersistenceManager.getByID(mod.getID(), InventoryRemove.class);
        }
        return obj;
    }
}

