/*
 * Decompiled with CFR 0.152.
 */
package ordermate.diff.stringifier;

import au.com.ordermate.util.Stringifier;
import ordermate.OrderMate;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.inventory.InventoryOptionGroupLink;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;

public class OptionGroupLinkStringifier
implements Stringifier<InventoryOptionGroupLink> {
    @Override
    public String stringify(InventoryOptionGroupLink optionGroupLink) {
        long displayId = 0L;
        InventoryOptionGroup optionGroup = optionGroupLink.getOptionGroup();
        if (optionGroup != null) {
            displayId = optionGroup.getID();
            if (OnlineIntegrationIDStrategy.MASTER_ID.equals((Object)SystemProperty.getInstance().getOnlineIntegrationIdStrategy())) {
                if (optionGroup.getMasterId() != null) {
                    displayId = optionGroup.getMasterId();
                } else {
                    OrderMate.LOG.warn("Master id is NOT generated for the object, Class type: " + optionGroup.getClass() + "ID: " + optionGroup.getID());
                    displayId = 0L;
                }
            }
        }
        return String.valueOf(displayId);
    }
}

