/*
 * Decompiled with CFR 0.152.
 */
package ordermate.diff.stringifier;

import au.com.ordermate.util.Stringifier;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;

public class StockItemLinkStringifier
implements Stringifier<StockInventoryUsageLink> {
    @Override
    public String stringify(StockInventoryUsageLink stockInventoryUsageLink) {
        long displayId = 0L;
        StockItem stockItem = stockInventoryUsageLink.getStockItem();
        if (stockItem != null) {
            displayId = stockItem.getID();
            if (OnlineIntegrationIDStrategy.MASTER_ID.equals((Object)SystemProperty.getInstance().getOnlineIntegrationIdStrategy())) {
                if (stockItem.getMasterId() != null) {
                    displayId = stockItem.getMasterId();
                } else {
                    OrderMate.LOG.warn("Master id is NOT generated for the object, Class type: " + stockItem.getClass() + "ID: " + stockItem.getID());
                    displayId = 0L;
                }
            }
        }
        return String.valueOf(displayId);
    }
}

