/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.io.Serializable;
import java.util.Collection;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.docketprocessor.DocketLog;
import ordermate.docketprocessor.DocketLogLevel;
import ordermate.docketprocessor.DocketRouter;

public abstract class AbstractPrintJob
implements Serializable {
    protected boolean printPreviewJob = false;

    protected abstract Collection<VirtualPrinter> getPrinters();

    protected void printingStarted() {
    }

    protected abstract void printingDone();

    public abstract String toString();

    public boolean isPrintPreviewJob() {
        return this.printPreviewJob;
    }

    protected abstract void doPrintDocket(VirtualPrinter var1, DocketRouter var2) throws Exception;

    public void doPrint(DocketRouter router) {
        for (VirtualPrinter printer : this.getPrinters()) {
            try {
                this.doPrintDocket(printer, router);
            }
            catch (Exception e) {
                e.printStackTrace();
                DocketLog.WriteLog("Error generating dockets for " + this + " on printer " + printer.getLabel(), DocketLogLevel.LogError, e);
            }
        }
    }
}

