/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.activitystatement.ActivityStatement;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;
import ordermate.reports.printing.ActivityStatementReport;

class ActivityStatementPrintJob
extends AbstractPrintJob {
    public static final String DOCKET_TYPE = "ACTIVITY_STATEMENT";
    private final AbstractDebtor debtor;
    private final Date from;
    private final Date to;
    private final Collection printers;
    private ActivityStatementReport statementReport;

    public ActivityStatementPrintJob(AbstractDebtor debtorToPrint, Date dateFrom, Date dateTo, Collection allPrinters) {
        this.debtor = debtorToPrint;
        this.from = dateFrom;
        this.to = dateTo;
        this.printers = allPrinters;
    }

    protected Collection getPrinters() {
        return this.printers;
    }

    @Override
    protected void printingDone() {
    }

    @Override
    public String toString() {
        return this.debtor + " activity stmt " + this.from + "-" + this.to;
    }

    @Override
    protected void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        ActivityStatement stmt = new ActivityStatement(this.debtor, this.from, this.to);
        if (printer.isWindowPrinter()) {
            if (this.statementReport == null) {
                this.statementReport = new ActivityStatementReport();
            }
            this.statementReport.setStatement(stmt);
            this.statementReport.generate();
            printer.getWindowsPrinter().print(this.statementReport, this.toString());
        } else {
            XmlDocket gDocket = GroovyDocket.getActivityStatementDocket();
            gDocket.setParams(Collections.singletonList(stmt));
            String xml = gDocket.generateXml();
            SalesAccountDocket docket = new SalesAccountDocket(printer, xml, this.toString(), DOCKET_TYPE);
            router.printDocket(docket);
        }
    }
}

