/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.docket.SimpleDocket;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;

public class CouponPrintJob
extends AbstractPrintJob {
    private final SalesCoupon coupon;
    private final EventContext context;

    CouponPrintJob(SalesCoupon coupon, EventContext context) {
        this.coupon = coupon;
        this.context = context;
    }

    @Override
    public Collection<VirtualPrinter> getPrinters() {
        List<VirtualPrinter> printerList = this.context.getTerminal().getAvailableReceiptPrinters();
        if (printerList.size() > 1) {
            VirtualPrinter toPrintFrom = printerList.get(0);
            printerList.clear();
            printerList.add(toPrintFrom);
        }
        return printerList;
    }

    @Override
    public String toString() {
        return "Print Coupon " + this.coupon.getUniqueId();
    }

    protected List<Object> getParams(VirtualPrinter printer) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.coupon);
        params.add(printer);
        return params;
    }

    @Override
    protected void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        XmlDocket gDocket = GroovyDocket.getCouponDocket();
        gDocket.setParams(this.getParams(printer));
        gDocket.setTemplate(DocketTemplate.findTemplate(DocketTemplate.DocketType.COUPON_DOCKET.getLabel()));
        String xml = gDocket.generateXml();
        SimpleDocket docket = new SimpleDocket(printer, xml, this.toString(), DocketTemplate.DocketType.COUPON_DOCKET.getLabel(), 0);
        router.printDocket(docket);
    }

    @Override
    protected void printingDone() {
    }
}

