/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.ArrayList;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.course.CoursePrintStatus;
import ordermate.database.course.SalesAccountCourse;
import ordermate.database.misc.Course;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.printSummary.PrepDocketHelper;
import ordermate.docketprocessor.PrepPrintJob;

public class CourseHoldPrepPrintJob
extends PrepPrintJob {
    CourseHoldPrepPrintJob(Account printAccount, EventContext context) {
        super(printAccount, context);
    }

    CourseHoldPrepPrintJob(Account printAccount, EventContext context, boolean prepsums, boolean rushed) {
        super(printAccount, context, prepsums, rushed);
    }

    @Override
    protected List<SalesItem> getItemsToPrint(PrepDocketHelper helper) {
        Account account = this.getAccount();
        List<Course> courses = Course.getCourses();
        ArrayList<SalesItem> finalList = new ArrayList<SalesItem>();
        for (Course course : courses) {
            TableAccount tableAccount;
            SalesAccountCourse salesAccountCourse;
            if (account instanceof TableAccount && (salesAccountCourse = (tableAccount = (TableAccount)account).getSalesAccountCourse(course)) != null && salesAccountCourse.getCoursePrintStatus() == CoursePrintStatus.HOLD) continue;
            finalList.addAll(helper.getItemsOnCourse(course, false));
        }
        return finalList;
    }
}

