/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.ArrayList;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.printSummary.PrepDocketHelper;
import ordermate.docketprocessor.PrepPrintJob;

public class CoursePrepPrintJob
extends PrepPrintJob {
    private int course;

    CoursePrepPrintJob(Account printAccount, EventContext context, int printUpToCourse) {
        super(printAccount, context);
        this.course = printUpToCourse;
    }

    @Override
    protected void markPrintedItemsAsPrinted(Account copyOfAccount) {
        PrepDocketHelper.create(copyOfAccount).markCourseItemsAsPrinted(this.course);
    }

    @Override
    protected List<SalesItem> getItemsToPrint(PrepDocketHelper helper) {
        return helper.getUnprintedItemsOnOrBeforeCourse(this.course);
    }

    @Override
    protected List<SalesItemQuantity> getQuantitiesToPrint() {
        return this.getPrintableItemQuantities();
    }

    private List<SalesItemQuantity> getPrintableItemQuantities() {
        ArrayList<SalesItemQuantity> qtys = new ArrayList<SalesItemQuantity>();
        for (SalesItem item : this.getItemsToPrint(PrepDocketHelper.create(this.getAccount()))) {
            qtys.addAll(item.getSalesItemQuantities());
        }
        return qtys;
    }
}

