/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.docket.SimpleDocket;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.Course;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.printSummary.PrepDocketHelper;
import ordermate.docketprocessor.AbstractTerminalPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;

public class CoursePrintJob
extends AbstractTerminalPrintJob {
    public static final String COURSE_DOCKET_TYPE = "COURSE";
    private TableAccount account;
    private Course course;

    CoursePrintJob(TableAccount theAccount, Course theCourse, EventContext newContext) {
        super(null, newContext);
        this.account = theAccount;
        this.course = theCourse;
    }

    @Override
    public Collection<VirtualPrinter> getPrinters() {
        List<SalesItem> allItemsForCourse = PrepDocketHelper.create(this.account, null).getCourseStateItems(this.course.getCourseIndex(), null);
        return VirtualPrinter.getDocketPrintersForItems(allItemsForCourse, this.getTerminal());
    }

    @Override
    protected String getDocketType() {
        return DocketTemplate.DocketType.COURSE_DOCKET.getLabel();
    }

    @Override
    protected DocketTemplate getTemplate() {
        DocketTemplate retValue = null;
        if (this.account != null) {
            retValue = DocketTemplate.getHighestTemplate(DocketTemplate.DocketType.COURSE_DOCKET, new TriggerActivationContext(this.getContext(), this.account));
        }
        return retValue;
    }

    @Override
    public String toString() {
        return "Call Course " + this.course.getName() + " For " + this.account.getLabel();
    }

    protected List<Object> getParams(VirtualPrinter printer) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.account);
        params.add(this.course);
        params.add(this.getTerminal().getSeatNums() && this.account.usesSeatNums());
        params.add(printer);
        params.add(this.getTerminal());
        params.add(this.getUser());
        return params;
    }

    @Override
    protected void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        XmlDocket gDocket = GroovyDocket.getCourseDocket();
        gDocket.setParams(this.getParams(printer));
        gDocket.setTemplate(this.getTemplate());
        String xml = gDocket.generateXml();
        SimpleDocket docket = new SimpleDocket(printer, xml, this.toString(), this.getDocketType(), 0);
        router.printDocket(docket);
    }
}

