/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.Collection;
import java.util.List;
import ordermate.database.finance.debtors.DebtorConfig;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.reports.printing.DebtorsSummaryReport;

public class DebtorSummaryPrintJob
extends AbstractPrintJob {
    private static volatile DebtorsSummaryReport debtorSummaryReport;
    private final List debtorsToPrint;
    private final Collection thePrinters;

    public DebtorSummaryPrintJob(List debtors, Collection printers) {
        this.debtorsToPrint = debtors;
        this.thePrinters = printers;
    }

    @Override
    public void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        String xmlFile = this.getXMLFile();
        if (xmlFile.endsWith(".xml")) {
            throw new UnsupportedOperationException("Debtor summary cannot be printed on POS printers");
        }
        if (xmlFile.endsWith(".jrxml")) {
            if (debtorSummaryReport == null) {
                debtorSummaryReport = new DebtorsSummaryReport(xmlFile);
            }
            debtorSummaryReport.setDebtors(this.debtorsToPrint);
            debtorSummaryReport.generate();
            printer.getWindowsPrinter().print(debtorSummaryReport, this.toString());
        }
    }

    public Collection getPrinters() {
        return this.thePrinters;
    }

    private String getXMLFile() {
        String retValue = "/ordermate/reports/printing/DebtorsSummaryReport.jrxml";
        DebtorConfig config = DebtorConfig.getInstance();
        if (config.getSummaryReportLocation() != null) {
            retValue = config.getSummaryReportLocation();
        }
        return retValue;
    }

    @Override
    public void printingDone() {
    }

    @Override
    public String toString() {
        return "Debtor Summary print job";
    }
}

