/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.networkio.IONotification;
import au.com.ordermate.simplermi.SimpleRMI;
import au.com.ordermate.util.Price;
import java.io.IOException;
import java.net.InetAddress;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JasperPrint;
import ordermate.database.EventContext;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.docket.FinanceTransactionDocket;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.finance.reports.SalesSummary;
import ordermate.database.finance.transactions.EftposTransaction;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.misc.Course;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.database.users.User;
import ordermate.database.workflow.QuantitiesToPrint;
import ordermate.database.workflow.action.WorkflowPrintAction;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.ActivityStatementPrintJob;
import ordermate.docketprocessor.CouponPrintJob;
import ordermate.docketprocessor.CourseHoldPrepPrintJob;
import ordermate.docketprocessor.CoursePrepPrintJob;
import ordermate.docketprocessor.CoursePrintJob;
import ordermate.docketprocessor.DebtorSummaryPrintJob;
import ordermate.docketprocessor.DocketLog;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.DriverSummaryPrintJob;
import ordermate.docketprocessor.EftposPrintJob;
import ordermate.docketprocessor.ExternalPrintJob;
import ordermate.docketprocessor.PayoffPrintJob;
import ordermate.docketprocessor.RePrintJob;
import ordermate.docketprocessor.ReceiptPrintJob;
import ordermate.docketprocessor.RemoteDocketProcessor;
import ordermate.docketprocessor.RemoteProcessorImpl;
import ordermate.docketprocessor.ReportPrintJob;
import ordermate.docketprocessor.ReservationsPrintJob;
import ordermate.docketprocessor.SalesSummaryPrintJob;
import ordermate.docketprocessor.SimplePrintJob;
import ordermate.docketprocessor.SkimPrintJob;
import ordermate.docketprocessor.StatementPrintJob;
import ordermate.docketprocessor.StockRequisitionPrintJob;
import ordermate.docketprocessor.TakingsPrintJob;
import ordermate.docketprocessor.TransferPrepPrintJob;
import ordermate.docketprocessor.VoucherPrintJob;
import ordermate.docketprocessor.WaitermateReportPrintJob;
import ordermate.docketprocessor.WaitermateReportType;
import ordermate.docketprocessor.WorkflowPrepPrintJob;

public class DocketProcessor {
    private static RemoteDocketProcessor remote;
    private static IONotification router;

    public static void printPrepDocket(Account toPrint, User user, Terminal printFrom, boolean rushed) throws IOException {
        DocketProcessor.printDocket(new CourseHoldPrepPrintJob(toPrint, new EventContext(printFrom, user), true, rushed));
    }

    public static void printPrepDocketForCourse(Account toPrint, User user, Terminal printFrom, int course) throws IOException {
        DocketProcessor.printDocket(new CoursePrepPrintJob(toPrint, new EventContext(printFrom, user), course));
    }

    public static void printWorkflowPrepDocket(Account toPrint, EventContext context, VirtualPrinter printer, Set<WorkflowPrintAction> printActions, List<SalesItemQuantity> itemQtys, Set<PrinterGroup> printerGroups, Map<VirtualPrinter, Set<QuantitiesToPrint>> notifyPrinterQtys, Account targetAccount, boolean printSums, boolean rushed) throws IOException {
        WorkflowPrepPrintJob prepJob = new WorkflowPrepPrintJob(toPrint, context, printer, printActions, itemQtys, printerGroups, targetAccount, printSums, rushed);
        prepJob.setNotifyPrinterQuantities(notifyPrinterQtys);
        DocketProcessor.printDocket(prepJob);
    }

    public static void printReportPrintJob(JasperPrint jasperPrint, Collection<VirtualPrinter> printers) throws IOException {
        DocketProcessor.printDocket(new ReportPrintJob(jasperPrint, printers));
    }

    public static void printTransferDocket(Account printAccount, Account targetAccount, User user, Terminal printFrom) throws IOException {
        DocketProcessor.printDocket(new TransferPrepPrintJob(printAccount, targetAccount, user, printFrom));
    }

    public static void printExternalDocket(ExternalPrintJob externalJob) throws IOException {
        DocketProcessor.printDocket(externalJob);
    }

    public static void printReceiptDocket(Collection<VirtualPrinter> virtualPrinters, ItemGroup printAccount, User user, Terminal printFrom) throws IOException {
        DocketProcessor.printDocket(new ReceiptPrintJob(virtualPrinters, printAccount, new EventContext(printFrom, user)));
    }

    public static void printPayoffDocket(Collection virtualPrinters, ItemGroup printAccount, User user, Terminal printFrom) throws IOException {
        DocketProcessor.printDocket(new PayoffPrintJob(virtualPrinters, printAccount, new EventContext(printFrom, user)));
    }

    public static void printStatementDocket(List debtorSales, Price openingBalance, String newDebtorName, Collection newPrinters) throws IOException {
        DocketProcessor.printDocket(new StatementPrintJob(debtorSales, openingBalance, newDebtorName, newPrinters));
    }

    public static void printDebtorSummary(List debtors, Collection newPrinters) throws IOException {
        DocketProcessor.printDocket(new DebtorSummaryPrintJob(debtors, newPrinters));
    }

    public static void printTakingsDocket(User user, Terminal printFrom, RestaurantTakingsSummary restaurantTakings, List cashdrawTakings, Collection newPrinters) throws IOException {
        DocketProcessor.printDocket(new TakingsPrintJob(restaurantTakings, cashdrawTakings, newPrinters, new EventContext(printFrom, user)));
        TerminalEventLog.logTakingsPrint(user, printFrom);
    }

    public static void printSalesDocket(User user, Terminal printFrom, Collection printers, SalesSummary summary) throws IOException {
        DocketProcessor.printDocket(new SalesSummaryPrintJob(printers, summary));
        TerminalEventLog.logSalesPrint(user, printFrom);
    }

    public static void printWaitermateReport(EventContext context, WaitermateReportType type, Collection<VirtualPrinter> printers, List<Object> params) throws IOException {
        DocketProcessor.printDocket(new WaitermateReportPrintJob(params, printers, type, context));
        TerminalEventLog.logTakingsPrint(context.getUser(), context.getTerminal());
    }

    public static void printDriverySummaryDocket(User driver, TradingDay start, TradingDay end, List<VirtualPrinter> printers, EventContext eventContext) throws IOException {
        DriverSummaryPrintJob printJob = new DriverSummaryPrintJob(driver, start, end, printers, eventContext);
        DocketProcessor.printDocket(printJob);
    }

    public static void printStockRequisitionDocket(StockRequisitionOrder toPrint, List<VirtualPrinter> printers, EventContext eventContext) throws IOException {
        StockRequisitionPrintJob printJob = new StockRequisitionPrintJob(toPrint, printers, eventContext);
        DocketProcessor.printDocket(printJob);
        toPrint.setPrinted(true);
        toPrint.save();
    }

    public static void printReservationsDocket(Terminal printFrom, Collection newPrinters, Date theDate) throws IOException {
        DocketProcessor.printDocket(new ReservationsPrintJob(printFrom, newPrinters, theDate));
    }

    public static void printSkimDocket(Terminal printFrom, Collection newPrinters, List theSkims) throws IOException {
        DocketProcessor.printDocket(new SkimPrintJob(printFrom, newPrinters, theSkims));
    }

    public static void printActivityStatementDocket(AbstractDebtor debtor, Date from, Date to, Collection printers) throws IOException {
        DocketProcessor.printDocket(new ActivityStatementPrintJob(debtor, from, to, printers));
    }

    public static void printEftposDocket(String docket, Collection<VirtualPrinter> printers, EftposTransaction relatedTxn, boolean isCustomerCopy) throws IOException {
        EftposPrintJob eftPrintJob = new EftposPrintJob(docket, printers);
        DocketProcessor.printDocket(eftPrintJob);
        if (isCustomerCopy && relatedTxn != null) {
            FinanceTransactionDocket ftDocket = eftPrintJob.getPrintableDocket();
            relatedTxn.addDocket(ftDocket);
            ftDocket.save();
        }
    }

    public static void printSimpleDocket(String docket, Collection<VirtualPrinter> printers) throws IOException {
        DocketProcessor.printDocket(new SimplePrintJob(docket, printers));
    }

    public static void printSimpleDocket(SimplePrintJob simplePrintJob) throws Exception {
        DocketProcessor.printDocket(simplePrintJob);
    }

    public static void printSimpleDocket(String docket) throws IOException {
        DocketProcessor.printDocket(new SimplePrintJob(docket));
    }

    public static void printSimpleDocketWithHeader(String docket) throws IOException {
        DocketProcessor.printDocket(new SimplePrintJob(docket, true));
    }

    public static void printVoucher(GiftVoucher voucher, EventContext context) throws IOException {
        DocketProcessor.printDocket(new VoucherPrintJob(voucher, context));
    }

    public static void printCouponDocket(SalesCoupon coupon, EventContext context) throws IOException {
        DocketProcessor.printDocket(new CouponPrintJob(coupon, context));
    }

    public static void printCourseDocket(TableAccount account, Course course, User user, Terminal terminal) throws IOException {
        EventContext context = new EventContext(terminal, user);
        DocketProcessor.printDocket(new CoursePrintJob(account, course, context));
    }

    public static void rePrintDocket(AbstractDocket docket) throws IOException {
        DocketProcessor.printDocket(new RePrintJob(docket));
    }

    public static int getQueueSize() throws IOException {
        return remote.getQueueSize();
    }

    private static void printDocket(AbstractPrintJob toPrint) throws IOException {
        if (remote == null) {
            throw new IllegalStateException("Must call connect to establish server connection, before printing.");
        }
        remote.printDocket(toPrint);
    }

    public static void startServer() throws RemoteException {
        DocketLog.setup(!Config.getBooleanValue("debug"));
        router = new DocketRouter();
        SimpleRMI.shareObject(router, "Docket Router Service");
        remote = new RemoteProcessorImpl((DocketRouter)router);
        SimpleRMI.shareObject(remote, "XML Docket processing service");
    }

    public static void connect(InetAddress address, int port) throws RemoteException, NotBoundException {
        remote = (RemoteDocketProcessor)SimpleRMI.getObject(address, "XML Docket processing service", port);
        router = (IONotification)SimpleRMI.getObject(address, "Docket Router Service", port);
    }

    public static void setRemoteProcessor(RemoteDocketProcessor remoteProcessor) {
        remote = remoteProcessor;
    }

    public static RemoteDocketProcessor getRemoteProcessor() {
        return remote;
    }
}

