/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import au.com.ordermate.networkio.IONotification;
import au.com.ordermate.networkio.JobID;
import au.com.ordermate.networkio.NotificationDetails;
import au.com.ordermate.simplermi.SimpleRMI;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import ordermate.OrderMate;
import ordermate.database.docket.AbstractDocket;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.misc.CustomParameter;
import ordermate.database.misc.SystemProperty;
import ordermate.database.workflow.WorkflowManager;
import ordermate.docketprocessor.DocketLog;
import ordermate.docketprocessor.DocketLogLevel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class DocketRouter
extends UnicastRemoteObject
implements IONotification {
    public static final String ROUTER_SERVICE_NAME = "Docket Router Service";
    public static final long RETRY_DELAY_DEFAULT = 60000L;
    static long TIME_TO_TRY;
    protected final Map<JobID, AbstractDocket> docketMap = new HashMap<JobID, AbstractDocket>();
    protected final Object docketMapMonitor = new Object();
    private final List<AbstractDocket> stalledDockets = new ArrayList<AbstractDocket>();
    private final Object stalledDocketsMonitor = new Object();
    private int jobCount = 0;
    protected long retryDelay = 60000L;
    private final Set<PhysicalPrintDevice> brokenPrinters = new HashSet<PhysicalPrintDevice>();
    private final Object brokenPrintersMonitor = new Object();
    private Signal docketDone = Signals.createSignal(AbstractDocket.class, "docketFinishedPrinting");

    public DocketRouter() throws RemoteException {
        TIME_TO_TRY = (long)SystemProperty.getInstance().getPrinterTimeout() * 1000L;
        CustomParameter retryParam = CustomParameter.getCustomParameter("Printing", "Retry Delay");
        if (retryParam != null) {
            try {
                this.retryDelay = retryParam.getLong(60000L);
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Cannot read retry parameter, defaulting to 60s");
            }
        }
        this.scheduleRetryThread();
        this.docketDone.connect(WorkflowManager.getInstance(), "docketFinishedPrinting");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PhysicalPrintDevice findPrinter(AbstractDocket docket) {
        PhysicalPrintDevice printer;
        HashSet<PhysicalPrintDevice> visitedPrinters = new HashSet<PhysicalPrintDevice>();
        do {
            PhysicalPrintDevice lastPrinter = docket.getLastPrinter();
            printer = docket.getNextPrinter();
            if (printer != null) {
                Object object = this.brokenPrintersMonitor;
                synchronized (object) {
                    if (!this.brokenPrinters.contains(printer)) {
                        return printer;
                    }
                }
                DocketLog.WriteLog("Printer " + printer.getLabel() + " is known to be broken. Redirecting.");
                continue;
            }
            DocketLog.WriteLog("Printer : " + lastPrinter + " does not have a backup printer.");
        } while (printer != null && visitedPrinters.add(printer));
        return null;
    }

    public void printDocket(AbstractDocket docket) {
        PhysicalPrintDevice printer = this.findPrinter(docket);
        this.printDocketToPrinter(docket, printer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printDocketToPrinter(AbstractDocket docket, PhysicalPrintDevice printer) {
        docket.setLastPrinter(printer);
        if (!docket.isPreviewDocket()) {
            docket.save();
        }
        if (printer == null) {
            Object object = this.stalledDocketsMonitor;
            synchronized (object) {
                this.stalledDockets.add(docket);
            }
            DocketLog.WriteLog("Could not find printer for " + docket.toString() + ", adding to stalled dockets");
        } else {
            JobID id;
            DocketRouter docketRouter = this;
            synchronized (docketRouter) {
                ++this.jobCount;
                id = new JobID(this.jobCount, printer.getLabel(), docket.getDescription());
            }
            if (SystemProperty.getInstance().isPrinterRedirection()) {
                this.doPrintWithErrorControl(printer, docket, id);
            } else {
                this.doPrintNoErrorControl(printer, docket);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPrintWithErrorControl(PhysicalPrintDevice printer, AbstractDocket docket, JobID jobID) {
        try {
            Object object = this.docketMapMonitor;
            synchronized (object) {
                this.docketMap.put(jobID, docket);
            }
            printer.print(docket, this.getDetails(jobID));
        }
        catch (IOException e) {
            e.printStackTrace();
            DocketLog.WriteLog("Could not set " + docket.toString() + " to printer : " + docket.getLastPrinter() + " attempting printer redirection", DocketLogLevel.LogError, e);
            this.jobError(jobID);
        }
    }

    protected void doPrintNoErrorControl(PhysicalPrintDevice printer, AbstractDocket docket) {
        try {
            printer.print(docket, null);
        }
        catch (IOException e) {
            DocketLog.WriteLog("Could not set " + docket.toString() + " to printer : " + docket.getLastPrinter() + " printer redirection is not turned on.", DocketLogLevel.LogError, e);
            this.reprintDocket(docket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobComplete(JobID jobID) {
        AbstractDocket doneDocket;
        Object object = this.docketMapMonitor;
        synchronized (object) {
            doneDocket = this.docketMap.remove(jobID);
        }
        if (doneDocket == null) {
            DocketLog.WriteLog("Completed docket not found in map");
        } else {
            DocketLog.WriteLog("Finished processing " + doneDocket.toString());
        }
        object = doneDocket;
        synchronized (object) {
            this.docketDone.emit(doneDocket);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobError(JobID jobID) {
        AbstractDocket failedDocket;
        Object object = this.docketMapMonitor;
        synchronized (object) {
            failedDocket = this.docketMap.remove(jobID);
        }
        if (failedDocket == null) {
            DocketLog.WriteLog("Could not find docket to reprint for jobID : " + jobID + " printer redirect may be turned off.  Printer redirect is : " + SystemProperty.getInstance().isPrinterRedirection());
            return;
        }
        this.reprintDocket(failedDocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reprintDocket(AbstractDocket failedDocket) {
        DocketLog.WriteLog(failedDocket.toString() + " failed, attempting to redirect");
        Object object = this.brokenPrintersMonitor;
        synchronized (object) {
            this.brokenPrinters.add(failedDocket.getLastPrinter());
        }
        this.printDocket(failedDocket);
    }

    private NotificationDetails getDetails(JobID id) {
        return new NotificationDetails(Terminal.getLocalHost().getAddress(), SimpleRMI.getSharePort(), ROUTER_SERVICE_NAME, TIME_TO_TRY, id);
    }

    protected void scheduleRetryThread() {
        Timer threadTimer = new Timer();
        threadTimer.schedule((TimerTask)new DocketRetry(), this.retryDelay);
    }

    protected List<AbstractDocket> getStalledDockets() {
        return this.stalledDockets;
    }

    @Override
    public void jobStarted(JobID jobID) {
    }

    private class DocketRetry
    extends TimerTask {
        private DocketRetry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = DocketRouter.this.brokenPrintersMonitor;
                synchronized (object) {
                    if (DocketRouter.this.brokenPrinters.size() > 0) {
                        DocketLog.WriteLog("Clearing broken printers list and retrying, size was :" + DocketRouter.this.brokenPrinters.size());
                        DocketRouter.this.brokenPrinters.clear();
                    }
                }
                int stalledDocketsSize = 0;
                Object object2 = DocketRouter.this.stalledDocketsMonitor;
                synchronized (object2) {
                    stalledDocketsSize = DocketRouter.this.stalledDockets.size();
                }
                if (stalledDocketsSize > 0) {
                    DocketLog.WriteLog("Re-trying to print " + DocketRouter.this.stalledDockets.size() + " dockets");
                    ArrayList docketsToRetry = new ArrayList(DocketRouter.this.stalledDockets);
                    for (AbstractDocket stalledDocket : docketsToRetry) {
                        Object object3 = DocketRouter.this.stalledDocketsMonitor;
                        synchronized (object3) {
                            DocketRouter.this.stalledDockets.remove(stalledDocket);
                        }
                        DocketRouter.this.printDocket(stalledDocket);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException ex) {
                            OrderMate.LOG.info("Interrupted while trying to print stalled dockets", (Throwable)ex);
                            break;
                        }
                    }
                }
                object2 = DocketRouter.this.brokenPrintersMonitor;
                synchronized (object2) {
                    DocketRouter.this.brokenPrinters.clear();
                }
            }
            finally {
                DocketRouter.this.scheduleRetryThread();
            }
        }
    }
}

