/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.docket.SimpleDocket;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.finance.timesheet.FinanceTimesheetQueries;
import ordermate.database.queries.sales.DeliveryQueries;
import ordermate.database.sales.Delivery;
import ordermate.database.users.User;
import ordermate.docketprocessor.AbstractTerminalPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;

public class DriverSummaryPrintJob
extends AbstractTerminalPrintJob {
    private final User driver;
    private final TradingDay startDay;
    private final TradingDay endDay;

    public DriverSummaryPrintJob(User driver, TradingDay start, TradingDay end, List printers, EventContext newContext) {
        super(printers, newContext);
        this.driver = driver;
        if (start == null) {
            throw new IllegalArgumentException("Start shift cannot be null");
        }
        if (end == null) {
            throw new IllegalArgumentException("End shift cannot be null");
        }
        this.startDay = start;
        this.endDay = end;
    }

    @Override
    protected String getDocketType() {
        return DocketTemplate.DocketType.DRIVER_SUMMARY.toString();
    }

    @Override
    protected DocketTemplate getTemplate() {
        return DocketTemplate.getHighestTemplate(DocketTemplate.DocketType.DRIVER_SUMMARY, new TriggerActivationContext(this.getContext()));
    }

    @Override
    public String toString() {
        return DocketTemplate.DocketType.DRIVER_SUMMARY + "";
    }

    public List getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.driver);
        params.add(this.startDay);
        params.add(this.endDay);
        params.add(PersistenceManager.getObjectList(Delivery.class, DeliveryQueries.getDeliveriesForTradingDay(this.driver, this.startDay, this.endDay).toString()));
        Calendar closingCal = null;
        closingCal = this.endDay.equals(this.startDay) || this.endDay.getCloseDateTime() == null ? Calendar.getInstance() : DateTimeUtils.getCalendar(this.endDay.getCloseDateTime());
        List<FinanceTimesheet> clockins = FinanceTimesheetQueries.getTimesheetsClockedInOrOutWithinForUser(DateTimeUtils.getCalendar(this.startDay.getOpenDateTime()), closingCal, this.driver);
        params.add(clockins);
        return params;
    }

    @Override
    protected void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        XmlDocket xmlDocket = GroovyDocket.getDriverSummary();
        xmlDocket.setParams(this.getParams());
        xmlDocket.setTemplate(this.getTemplate());
        String xml = xmlDocket.generateXml();
        SimpleDocket docket = new SimpleDocket(printer, xml, this.toString(), DocketTemplate.DocketType.DRIVER_SUMMARY + "", 0);
        router.printDocket(docket);
    }
}

