/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.DocketRouter;

public class ExternalPrintJob
extends AbstractPrintJob
implements Serializable {
    public static final String EXTERNAL_DOCKET_TYPE = "EXTERNAL";
    private final Collection<VirtualPrinter> printers = new ArrayList<VirtualPrinter>();
    private String xmlString;

    public ExternalPrintJob(String newXmlString, VirtualPrinter vPrinter) {
        this.printers.add(vPrinter);
        this.xmlString = newXmlString;
    }

    @Override
    protected void doPrintDocket(VirtualPrinter thePrinter, DocketRouter router) throws Exception {
        SalesAccountDocket docket = new SalesAccountDocket(thePrinter, this.xmlString, this.toString(), EXTERNAL_DOCKET_TYPE);
        router.printDocket(docket);
    }

    public Collection getPrinters() {
        return this.printers;
    }

    public String getXml() {
        return this.xmlString;
    }

    @Override
    public void printingDone() {
    }

    @Override
    public String toString() {
        return "External Print Job";
    }
}

