/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.Collection;
import ordermate.database.EventContext;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.ItemGroup;
import ordermate.docketprocessor.ReceiptPrintJob;

class PayoffPrintJob
extends ReceiptPrintJob {
    public static final String PAY_OFF = "PAY OFF";

    public PayoffPrintJob(Collection printers, ItemGroup account, EventContext context) {
        super(printers, account, context);
    }

    @Override
    public String getDocketType() {
        return PAY_OFF;
    }

    public String getXMLFile(VirtualPrinter printer) {
        String fileLoc = printer.getPayoffXMLFile(this.getTerminal());
        if (fileLoc == null || fileLoc.isEmpty()) {
            fileLoc = SystemProperty.getInstance().getReceiptDocketLocation();
        }
        return fileLoc;
    }

    @Override
    public String toString() {
        return this.getItemGroup().getLabel() + " Pay Off dockets";
    }
}

