/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import au.com.ordermate.persistence.FKReference;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketPrinter;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.sales.Account;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.printSummary.PrepDocketHelper;
import ordermate.database.users.User;
import ordermate.docketprocessor.AbstractTerminalPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;
import ordermate.integration.bartabs.BarTabAdministrator;
import ordermate.reports.printing.TicketPrepReport;

public class PrepPrintJob
extends AbstractTerminalPrintJob {
    protected static final int TARGET = 5;
    protected static final int USER = 4;
    protected static final int TERMINAL = 3;
    protected static final int NOTIFIER_PRINTER_INDEX = 9;
    protected static final int NOTIFIER_QUANTITIES_INDEX = 10;
    protected static final int WORKFLOW_NOTIFIER_SET = 11;
    public static final String PREP_DOCKET_TYPE = "PREP";
    private static final Object prepDocketMonitor = new Object();
    private Reference<Account> accountReference = new FKReference<Account>(Account.class);
    private static HashMap<String, TicketPrepReport> prepReports = new HashMap();
    private SalesAccountDocket docket;
    protected boolean prepareSummaries = true;
    private boolean rushed = false;

    PrepPrintJob(Account printAccount, EventContext context) {
        super(null, context);
        if (!printAccount.isPersistent()) {
            throw new IllegalStateException("Account must be saved to be printed in prep job");
        }
        this.accountReference.set(printAccount);
        this.accountReference.collapse();
    }

    PrepPrintJob(Account printAccount, EventContext context, boolean prepsums, boolean rushed) {
        this(printAccount, context);
        this.prepareSummaries = prepsums;
        this.rushed = rushed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void printingStarted() {
        Object object = prepDocketMonitor;
        synchronized (object) {
            Account account = this.getAccount();
            if (account == null) {
                return;
            }
            Iterator<SalesLineItem> it = account.getAllItems().iterator();
            while (it.hasNext()) {
                it.next().expandQuantities();
            }
            Account copyOfAccount = (Account)PersistenceManager.reacquire(this.getAccount());
            this.markPrintedItemsAsPrinted(copyOfAccount);
            if (copyOfAccount instanceof BarTabAccount) {
                BarTabAdministrator.getInstance().getBarTabAuthorityForAccount((BarTabAccount)copyOfAccount).addBarTabNotToSendStatusUpdatesFor((BarTabAccount)copyOfAccount);
            }
            copyOfAccount.save();
            if (copyOfAccount instanceof BarTabAccount) {
                BarTabAdministrator.getInstance().getBarTabAuthorityForAccount((BarTabAccount)copyOfAccount).removeBarTabNotToSendStatusUpdatesFor((BarTabAccount)copyOfAccount);
            }
        }
    }

    protected void markPrintedItemsAsPrinted(Account copyOfAccount) {
        PrepDocketHelper.create(copyOfAccount).markItemsAsPrinted();
    }

    @Override
    public String getDocketType() {
        return PREP_DOCKET_TYPE;
    }

    protected List getParams(VirtualPrinter printer) {
        boolean usesSeatNums = this.getTerminal().getSeatNums() && this.getAccount().usesSeatNums();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getAccount());
        params.add(usesSeatNums);
        params.add(printer);
        params.add(this.getTerminal());
        params.add(this.getUser());
        params.add(null);
        params.add(new Integer(printer.getDocketNumber() + 1));
        params.add(Boolean.FALSE);
        params.add(this.getQuantitiesToPrint());
        params.add(null);
        params.add(null);
        params.add(Boolean.FALSE);
        return params;
    }

    protected List<SalesItemQuantity> getQuantitiesToPrint() {
        return null;
    }

    @Override
    public Collection<VirtualPrinter> getPrinters() {
        List<VirtualPrinter> summaryPrinters;
        PrepDocketHelper docketHelper = PrepDocketHelper.create(this.getAccount());
        List<SalesItem> itemsToPrint = this.getItemsToPrint(docketHelper);
        Collection<VirtualPrinter> virtualPrinters = this.determinePrintersForItems(itemsToPrint, this.getTerminal());
        if (this.prepareSummaries && !(summaryPrinters = docketHelper.getSummaryPrinters()).isEmpty()) {
            LinkedHashSet<VirtualPrinter> newVirtualPrinters = new LinkedHashSet<VirtualPrinter>(virtualPrinters);
            newVirtualPrinters.addAll(summaryPrinters);
            return newVirtualPrinters;
        }
        return virtualPrinters;
    }

    protected List<SalesItem> getItemsToPrint(PrepDocketHelper helper) {
        return helper.getAllItems(Boolean.FALSE);
    }

    protected Collection<VirtualPrinter> determinePrintersForItems(List<SalesItem> itemsToPrint, Terminal terminal) {
        Collection<VirtualPrinter> printers = VirtualPrinter.getDocketPrintersForItems(itemsToPrint, terminal);
        if (!itemsToPrint.isEmpty() && (printers == null || printers.isEmpty())) {
            OrderMate.LOG.warn("** No Printers found for Prep Print Job - please check Printer Location Settings for " + itemsToPrint.get(0).getLabel() + " at terminal " + terminal.getLabel());
        }
        ArrayList<VirtualPrinter> ktsNotifiers = new ArrayList<VirtualPrinter>();
        for (VirtualPrinter printer : printers) {
            for (VirtualPrinter notify : printer.getNotifyPrinters()) {
                if (!(notify.getPrintDevice() instanceof KTSDocketPrinter)) continue;
                ktsNotifiers.add(notify);
            }
        }
        printers.addAll(ktsNotifiers);
        return printers;
    }

    @Override
    public void printingDone() {
    }

    @Override
    public String toString() {
        Account account = this.getAccount();
        if (account != null) {
            return this.getAccount().getLabel() + " " + account.getID() + " Prep dockets";
        }
        return this.accountReference.getObjectID() + "Prep dockets";
    }

    @Override
    protected void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        String printFileName = printer.getPrepDocketFile();
        if (printFileName != null && printFileName.endsWith(".jrxml")) {
            this.printJasperPrep(printFileName, printer);
        } else {
            this.printGroovyPrep(printFileName, printer, router);
        }
    }

    private TicketPrepReport getJasperPrepReport(String jasperFileName) {
        if (!prepReports.containsKey(jasperFileName)) {
            prepReports.put(jasperFileName, new TicketPrepReport(jasperFileName));
        }
        return prepReports.get(jasperFileName);
    }

    private void printJasperPrep(String jasperFileName, VirtualPrinter printer) throws Exception {
        TicketPrepReport reportToUse = this.getJasperPrepReport(jasperFileName);
        PrepDocketHelper helper = PrepDocketHelper.create(this.getAccount());
        List<SalesItem> items = printer.getItemsPrintableThrough(this.getTerminal(), helper.getAllItems((Boolean)false, "ACTIVE"));
        if (jasperFileName != null && jasperFileName.contains("split")) {
            reportToUse.setSplitQty(true);
        }
        reportToUse.setItems(items);
        reportToUse.generate();
        printer.getWindowsPrinter().print(reportToUse, this.toString());
    }

    protected JasperPrint getJasperPrint(String jasperFileName, VirtualPrinter printer) throws Exception {
        TicketPrepReport reportToUse = this.getJasperPrepReport(jasperFileName);
        PrepDocketHelper helper = PrepDocketHelper.create(this.getAccount());
        List<SalesItem> items = printer.getItemsPrintableThrough(this.getTerminal(), helper.getAllItems((Boolean)false, "ACTIVE"));
        reportToUse.setItems(items);
        reportToUse.generate();
        return reportToUse.getReport();
    }

    private void printGroovyPrep(String printFileName, VirtualPrinter printer, DocketRouter router) {
        List params = this.getParams(printer);
        String xml = this.createGroovyXML(printFileName, params);
        printer.incrementDocketNumber();
        this.docket = this.createSalesDocket(printer, xml);
        printer.save();
        this.docket.setTargetAccount((Account)params.get(5));
        this.docket.setUser((User)params.get(4));
        this.docket.setTerminal((Terminal)params.get(3));
        router.printDocket(this.docket);
    }

    protected SalesAccountDocket createSalesDocket(VirtualPrinter printer, String xml) {
        SalesAccountDocket docket = new SalesAccountDocket(printer, xml, this.toString(), PREP_DOCKET_TYPE, this.getAccount(), printer.getDocketNumber());
        docket.setRushed(this.rushed);
        return docket;
    }

    protected String createGroovyXML(String printFileName, List params) {
        XmlDocket gDocket = GroovyDocket.getPrepDocket(printFileName);
        gDocket.setParams(params);
        gDocket.setTemplate(this.getTemplate());
        return gDocket.generateXml();
    }

    protected SalesAccountDocket getDocket() {
        return this.docket;
    }

    protected Account getAccount() {
        Account account = this.accountReference.get();
        if (account == null && this.accountReference.getObjectID() != null) {
            throw new IllegalStateException("Could not resolve account from database " + this.accountReference.getObjectID());
        }
        return account;
    }

    public boolean isRushed() {
        return this.rushed;
    }

    @Override
    protected DocketTemplate getTemplate() {
        return DocketTemplate.getHighestTemplate(DocketTemplate.DocketType.PREP_DOCKET, new TriggerActivationContext(this.getContext(), this.getAccount()));
    }

    public TriggerActivationContext createTriggerContext() {
        return new TriggerActivationContext(this.getContext(), this.getAccount());
    }
}

