/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.docketprocessor.AbstractTerminalPrintJob;
import ordermate.docketprocessor.DocketLog;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;
import ordermate.internationalization.Internationalization;
import ordermate.reports.printing.InvoiceReport;

class ReceiptPrintJob
extends AbstractTerminalPrintJob {
    public static final String RECEIPT_DOCKET_TYPE = "RECEIPT";
    private static InvoiceReport invoiceReport;
    private final ItemGroup itemGroup;

    public ReceiptPrintJob(Collection<VirtualPrinter> printers, ItemGroup account, EventContext context) {
        super(printers, context);
        this.itemGroup = account;
    }

    @Override
    public String getDocketType() {
        return RECEIPT_DOCKET_TYPE;
    }

    private List<Object> getParams(VirtualPrinter printer) {
        boolean usesSeatNums = this.getTerminal().getSeatNums() && this.getItemGroup().usesSeatNums();
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.getItemGroup());
        params.add(usesSeatNums);
        params.add(this.getUser());
        params.add(printer);
        params.add(this.getContext().getTerminal());
        return params;
    }

    public String getDocketFile(VirtualPrinter printer) {
        String fileLoc = printer.getReceiptXMLFile(this.getTerminal());
        if (fileLoc == null || fileLoc.isEmpty()) {
            fileLoc = SystemProperty.getInstance().getReceiptDocketLocation();
        }
        return fileLoc;
    }

    @Override
    public String toString() {
        return this.getItemGroup().getLabel() + " Receipt dockets";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        String xmlFile = this.getDocketFile(printer);
        if (xmlFile != null && xmlFile.endsWith(".jrxml")) {
            ReceiptPrintJob receiptPrintJob = this;
            synchronized (receiptPrintJob) {
                if (invoiceReport == null) {
                    invoiceReport = new InvoiceReport(xmlFile, "");
                }
            }
            invoiceReport.setAccount(this.getItemGroup());
            invoiceReport.generate();
            printer.getWindowsPrinter().print(invoiceReport, this.toString());
        } else {
            String customGroovy = null;
            if (xmlFile != null && !xmlFile.isEmpty() && !xmlFile.endsWith(".groovy")) {
                DocketLog.getLogger().debug("The receipt docket file " + xmlFile + "is ignored for the printer " + printer);
            } else {
                customGroovy = xmlFile;
            }
            XmlDocket gDocket = GroovyDocket.getReceiptDocket(customGroovy);
            gDocket.setParams(this.getParams(printer));
            gDocket.setTemplate(this.getTemplate());
            String xml = gDocket.generateXml();
            if (Internationalization.getActiveResourceBundleForMoney().getLocale().toString().equals("en_NZ")) {
                xml = xml.replace(BusinessInfo.getInstance().getBusinessNumberType(), "GST Number");
                xml = xml.replace(BusinessInfo.getInstance().getAbn(), BusinessInfo.getInstance().getGstNum());
            }
            SalesAccountDocket docket = new SalesAccountDocket(printer, xml, this.toString(), this.getDocketType(), this.getItemGroup());
            router.printDocket(docket);
        }
    }

    protected ItemGroup getItemGroup() {
        return this.itemGroup;
    }

    @Override
    protected DocketTemplate getTemplate() {
        DocketTemplate retValue = null;
        if (this.getItemGroup().getAccount() != null) {
            Account account = this.getItemGroup().getAccount();
            retValue = DocketTemplate.getHighestTemplate(DocketTemplate.DocketType.RECEIPT, new TriggerActivationContext(this.getContext(), account));
        }
        return retValue;
    }
}

