/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import au.com.ordermate.persistence.PersistenceManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.PhysicalPrinter;
import ordermate.database.misc.SystemProperty;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.DocketLog;
import ordermate.docketprocessor.DocketLogLevel;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.PrintJobInterceptor;
import ordermate.docketprocessor.RemoteDocketProcessor;

public class RemoteProcessorImpl
extends UnicastRemoteObject
implements RemoteDocketProcessor {
    private static final int LARGE_AMOUNT_OF_DOCKETS_IN_QUEUE = 4;
    private List<PrintJobInterceptor> interceptors = new ArrayList<PrintJobInterceptor>();
    private BlockingQueue<AbstractPrintJob> docketQueue = new LinkedBlockingQueue<AbstractPrintJob>();
    private DocketRouter router;

    protected RemoteProcessorImpl(DocketRouter theRouter) throws RemoteException {
        this.router = theRouter;
        Thread processor = new Thread(new CallProcessor());
        processor.setName("XML docket processor");
        processor.start();
        int multiProcessing = SystemProperty.getInstance().getMultiProcessorPrinting();
        if (multiProcessing > 0 && this.docketQueue.size() >= 4) {
            int count = multiProcessing;
            for (int i = 1; i <= count; ++i) {
                Thread nextProcessor = new Thread(new CallProcessor());
                nextProcessor.setName("XML docket processor " + i);
                nextProcessor.setDaemon(true);
                nextProcessor.start();
            }
        }
    }

    @Override
    public void printDocket(AbstractPrintJob toPrint) throws RemoteException {
        AbstractPrintJob localPrintJob = null;
        for (PrintJobInterceptor interceptor : this.interceptors) {
            localPrintJob = interceptor.interceptPrintJob(toPrint);
            if (localPrintJob != null) continue;
            DocketLog.WriteLog("Docket " + toPrint + " was free by interceptor " + interceptor);
            return;
        }
        DocketLog.WriteLog("Got " + localPrintJob + ", adding to docket queue (Queue size now aprox " + (this.docketQueue.size() + 1) + ")");
        localPrintJob.printingStarted();
        this.docketQueue.add(localPrintJob);
    }

    @Override
    public int getQueueSize() throws RemoteException {
        return this.docketQueue.size();
    }

    public void addPrintJobInterceptor(PrintJobInterceptor printJobInterceptor) {
        this.interceptors.add(printJobInterceptor);
    }

    public List<PrintJobInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.interceptors);
    }

    private class QueueCrawler
    implements Runnable {
        private final AbstractPrintJob sampleJob;
        private final Set<VirtualPrinter> printers;

        QueueCrawler(AbstractPrintJob sampleJob) {
            this.sampleJob = sampleJob;
            this.printers = new HashSet<VirtualPrinter>(sampleJob.getPrinters());
            DocketLog.WriteLog("Queue Crawler activated for jobs without:" + Arrays.toString(this.printers.toArray()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AbstractPrintJob theJob = null;
            BlockingQueue blockingQueue = RemoteProcessorImpl.this.docketQueue;
            synchronized (blockingQueue) {
                for (AbstractPrintJob job : RemoteProcessorImpl.this.docketQueue) {
                    if (this.printers.containsAll(job.getPrinters())) continue;
                    theJob = job;
                    break;
                }
                if (theJob != null) {
                    RemoteProcessorImpl.this.docketQueue.remove(theJob);
                }
            }
            if (theJob != null) {
                long time = System.currentTimeMillis();
                try {
                    theJob.doPrint(RemoteProcessorImpl.this.router);
                    theJob.printingDone();
                }
                catch (Exception ex) {
                    DocketLog.WriteLog("Uncaught exception in printing thread for QueueCrawler!!!!", DocketLogLevel.LogError, ex);
                }
                DocketLog.WriteLog("QC took " + (System.currentTimeMillis() - time));
            }
        }
    }

    private class CallProcessor
    implements Runnable {
        private CallProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int count = 0;
            long time = 0L;
            while (true) {
                try {
                    AbstractPrintJob printJob;
                    BlockingQueue blockingQueue = RemoteProcessorImpl.this.docketQueue;
                    synchronized (blockingQueue) {
                        printJob = (AbstractPrintJob)RemoteProcessorImpl.this.docketQueue.take();
                        time = System.currentTimeMillis();
                    }
                    DocketLog.WriteLog(count + ": Removed " + printJob + " from queue (Queue size now aprox" + RemoteProcessorImpl.this.docketQueue.size() + ")");
                    if (SystemProperty.getInstance().getPrintQueueCrawler()) {
                        Thread queueCrawlerThread = new Thread(new QueueCrawler(printJob));
                        queueCrawlerThread.setName("Print Queue Crawler");
                        queueCrawlerThread.start();
                    }
                    PersistenceManager.getInstance().clearLocalCaches();
                    if (SystemProperty.getInstance().getPrintPortOptimisation() && this.isNoPrint(printJob)) {
                        DocketLog.WriteLog("Docket pointing to a none port, discarding:" + printJob);
                    } else {
                        printJob.doPrint(RemoteProcessorImpl.this.router);
                    }
                    printJob.printingDone();
                }
                catch (Exception e) {
                    DocketLog.WriteLog(count + ": Uncaught exception in printing thread!", DocketLogLevel.LogError, e);
                }
                DocketLog.WriteLog(count + " took " + (System.currentTimeMillis() - time));
                ++count;
            }
        }

        private boolean isNoPrint(AbstractPrintJob job) {
            for (VirtualPrinter printer : job.getPrinters()) {
                if (!(printer.getPrintDevice() instanceof PhysicalPrinter)) {
                    return false;
                }
                if ("None".equals(printer.getPrintDevice().getPort())) continue;
                return false;
            }
            return true;
        }
    }
}

