/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import au.com.ordermate.reports.AbstractReport;
import java.util.Collection;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import ordermate.OrderMate;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.PhysicalPrintDevice;
import ordermate.database.hardware.physical.PhysicalPrinter;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.DocketRouter;

public class ReportPrintJob
extends AbstractPrintJob {
    private Collection<VirtualPrinter> printers;
    private JasperPrint jasperPrint;

    public ReportPrintJob(JasperPrint jasperPrint, Collection<VirtualPrinter> printers) {
        this.printers = printers;
        this.jasperPrint = jasperPrint;
    }

    @Override
    protected Collection<VirtualPrinter> getPrinters() {
        return this.printers;
    }

    @Override
    protected void printingDone() {
    }

    @Override
    public String toString() {
        return this.jasperPrint.getName() + " Report Print Job";
    }

    @Override
    protected void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        PhysicalPrintDevice dev = printer.getPrintDevice();
        if (dev instanceof PhysicalPrinter && ((PhysicalPrinter)dev).getPortType().equals("Windows")) {
            AbstractReport toPrint = new AbstractReport(""){

                @Override
                protected JasperPrint runReport(JasperReport report) throws JRException {
                    return ReportPrintJob.this.jasperPrint;
                }

                @Override
                protected JasperReport loadReport() throws JRException {
                    return null;
                }

                @Override
                public JasperReport getJasperReport() {
                    return super.getJasperReport();
                }
            };
            toPrint.generate();
            ((PhysicalPrinter)dev).print(toPrint, "ReportPrintJob");
        } else {
            OrderMate.LOG.warn("Invalid printer: " + printer + ". This printer is not a windows printer and cannot print ReportPrintJob");
        }
    }
}

