/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;

public class ReservationsPrintJob
extends AbstractPrintJob {
    public static final String RESERVATION_DOCKET_TYPE = "RESERVATION";
    private final Terminal printTerm;
    private final Collection<VirtualPrinter> printers;
    private final Date date;

    public ReservationsPrintJob(Terminal printFrom, Collection<VirtualPrinter> newPrinters, Date theDate) {
        this.printTerm = printFrom;
        this.printers = newPrinters;
        this.date = new Date(theDate.getTime());
    }

    private List getParams() {
        ArrayList<Serializable> params = new ArrayList<Serializable>();
        params.add(this.printTerm);
        params.add(this.date);
        return params;
    }

    @Override
    public Collection<VirtualPrinter> getPrinters() {
        return this.printers;
    }

    @Override
    public void printingDone() {
    }

    @Override
    public String toString() {
        return "Reservations docket";
    }

    @Override
    public void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        XmlDocket gDocket = GroovyDocket.getReservationsDocket();
        gDocket.setParams(this.getParams());
        String xml = gDocket.generateXml();
        SalesAccountDocket docket = new SalesAccountDocket(printer, xml, this.toString(), RESERVATION_DOCKET_TYPE);
        router.printDocket(docket);
    }
}

