/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.finance.reports.SalesSummary;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;

public class SalesSummaryPrintJob
extends AbstractPrintJob {
    public static final String SALES_SUMMARY_DOCKET_TYPE = "SALES_SUMMARY";
    private final Collection printers;
    private final SalesSummary summary;

    public SalesSummaryPrintJob(Collection newPrinters, SalesSummary newSummary) {
        this.printers = newPrinters;
        this.summary = newSummary;
    }

    public List getParams() {
        ArrayList<SalesSummary> params = new ArrayList<SalesSummary>(1);
        params.add(this.summary);
        return params;
    }

    public Collection getPrinters() {
        return this.printers;
    }

    @Override
    public void printingDone() {
    }

    @Override
    public String toString() {
        return "Sales report";
    }

    @Override
    public void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        XmlDocket gDocket = GroovyDocket.getSalesSummaryDocket();
        gDocket.setParams(this.getParams());
        String xml = gDocket.generateXml();
        SalesAccountDocket docket = new SalesAccountDocket(printer, xml, this.toString(), SALES_SUMMARY_DOCKET_TYPE);
        router.printDocket(docket);
    }
}

