/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.database.docket.SimpleDocket;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.dockets.groovy.BasicXmlDocket;

public class SimplePrintJob
extends AbstractPrintJob {
    private static final String NAME = "Simple Print Job";
    private List<VirtualPrinter> printers;
    private List<String> linesToPrint;
    private String xml;

    public SimplePrintJob(String docketToPrint) {
        this(docketToPrint, false);
    }

    public SimplePrintJob(String docketToPrint, boolean printHeader) {
        List<VirtualPrinter> printerList = Terminal.getLocalHost().getAvailableReceiptPrinters();
        if (printerList.size() > 1) {
            ArrayList<VirtualPrinter> newList = new ArrayList<VirtualPrinter>();
            newList.add(printerList.get(0));
            printerList = newList;
        }
        this.doSetupCode(docketToPrint, printerList, printHeader);
    }

    public SimplePrintJob(String docketToPrint, Collection<VirtualPrinter> toPrintTo) {
        this.doSetupCode(docketToPrint, toPrintTo);
    }

    public SimplePrintJob(String docketContent, Collection<VirtualPrinter> toPrintTo, boolean previewMode) {
        this.printPreviewJob = previewMode;
        if (!previewMode) {
            this.doSetupCode(docketContent, toPrintTo, false);
            return;
        }
        this.printers = new ArrayList<VirtualPrinter>(toPrintTo);
        this.xml = docketContent;
    }

    private void doSetupCode(String docketToPrint, Collection<VirtualPrinter> toPrintTo) {
        this.doSetupCode(docketToPrint, toPrintTo, false);
    }

    private void doSetupCode(String docketToPrint, Collection<VirtualPrinter> toPrintTo, boolean printHeader) {
        this.printers = new ArrayList<VirtualPrinter>(toPrintTo);
        this.linesToPrint = this.convertToLines(docketToPrint);
        BasicXmlDocket xmlDocket = new BasicXmlDocket();
        xmlDocket.setPrintHeader(printHeader);
        xmlDocket.setParams(this.linesToPrint);
        this.xml = xmlDocket.generateXml();
    }

    private List<String> convertToLines(String value) {
        String[] splits = value.split("\\n");
        ArrayList<String> lines = new ArrayList<String>(splits.length);
        for (int i = 0; i < splits.length; ++i) {
            lines.add(splits[i]);
        }
        return lines;
    }

    @Override
    protected void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        SimpleDocket docket = new SimpleDocket(printer, this.getDocketXml(), "Preview Docket", null, 0);
        if (this.isPrintPreviewJob()) {
            docket.setPreviewDocket(true);
        }
        router.printDocket(docket);
    }

    protected String getDocketXml() {
        return this.xml;
    }

    protected List<VirtualPrinter> getPrintersList() {
        return this.printers;
    }

    public Collection getPrinters() {
        return this.printers;
    }

    @Override
    protected void printingDone() {
    }

    @Override
    public String toString() {
        return NAME;
    }
}

