/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;

public class SkimPrintJob
extends AbstractPrintJob {
    public static final String SKIM_DOCKET_TYPE = "SKIM";
    private final Terminal printTerm;
    private final Collection printers;
    private final List skims;

    public SkimPrintJob(Terminal printFrom, Collection newPrinters, List tehSkims) {
        this.printTerm = printFrom;
        this.printers = newPrinters;
        this.skims = tehSkims;
    }

    public List getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.printTerm);
        params.add(this.skims);
        return params;
    }

    public Collection getPrinters() {
        return this.printers;
    }

    @Override
    public void printingDone() {
    }

    @Override
    public String toString() {
        return "Skim docket";
    }

    @Override
    public void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        XmlDocket gDocket = GroovyDocket.getSkimsDocket();
        gDocket.setParams(this.getParams());
        String xml = gDocket.generateXml();
        SalesAccountDocket docket = new SalesAccountDocket(printer, xml, this.toString(), SKIM_DOCKET_TYPE);
        router.printDocket(docket);
    }
}

