/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorConfig;
import ordermate.database.finance.debtors.DebtorsSummary;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.print.DebtorStatementLinePrintData;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;
import ordermate.reports.printing.StatementReport;

public class StatementPrintJob
extends AbstractPrintJob {
    private static StatementReport statementReport;
    private final List debtorSales;
    private final Price openingBalance;
    private final String debtorName;
    private final Collection printers;
    public static final String DEBTOR_DOCKET_TYPE = "DEBTOR";

    public StatementPrintJob(List newDebtorSales, Price newOpeningBalance, String newDebtorName, Collection newPrinters) {
        if (newDebtorSales.size() == 0) {
            throw new IllegalArgumentException("The debtor sale is empty, cannot print the statement.");
        }
        this.debtorSales = newDebtorSales;
        this.openingBalance = newOpeningBalance;
        this.debtorName = newDebtorName;
        this.printers = newPrinters;
    }

    public String getDocketType() {
        return DEBTOR_DOCKET_TYPE;
    }

    private List getParams() {
        DebtorSale sale = (DebtorSale)this.debtorSales.get(0);
        AbstractDebtor debtor = sale.getDebtor();
        List statementPrintData = DebtorStatementLinePrintData.getDebtorStatementLinePrintData(this.debtorSales, this.openingBalance);
        DebtorsSummary summary = DebtorsSummary.summarize(debtor);
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(debtor);
        params.add(statementPrintData);
        params.add(summary);
        return params;
    }

    public Collection getPrinters() {
        return this.printers;
    }

    @Override
    public void printingDone() {
    }

    @Override
    public String toString() {
        return "Statement for " + this.debtorName;
    }

    private String getXMLFile() {
        String retValue = "/ordermate/reports/printing/StatementPrintDataReport.jrxml";
        DebtorConfig config = DebtorConfig.getInstance();
        if (config.getStatementReportLocation() != null) {
            retValue = config.getStatementReportLocation();
        }
        return retValue;
    }

    @Override
    public void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        if (printer.isWindowPrinter()) {
            String xmlFile = this.getXMLFile();
            if (xmlFile.endsWith(".jrxml")) {
                if (statementReport == null) {
                    statementReport = new StatementReport(xmlFile);
                }
                statementReport.setDebtorSales(this.debtorSales, this.openingBalance);
                statementReport.generate();
                printer.getWindowsPrinter().print(statementReport, this.toString());
            } else {
                OrderMate.LOG.warn("Could not print docket to windows printer, does not end with jrxml : " + xmlFile);
            }
        } else {
            XmlDocket gDocket = GroovyDocket.getStatementDocket();
            gDocket.setParams(this.getParams());
            String xml = gDocket.generateXml();
            SalesAccountDocket docket = new SalesAccountDocket(printer, xml, this.toString(), this.getDocketType());
            router.printDocket(docket);
        }
    }

    public List getDebtorSales() {
        return this.debtorSales;
    }

    public Price getOpeningBalance() {
        return this.openingBalance;
    }
}

