/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.Arrays;
import java.util.Collection;
import ordermate.database.EventContext;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.docket.SimpleDocket;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.stock.requisition.StockRequisitionOrder;
import ordermate.docketprocessor.AbstractTerminalPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;

public class StockRequisitionPrintJob
extends AbstractTerminalPrintJob {
    StockRequisitionOrder requisitionToPrint;

    StockRequisitionPrintJob(StockRequisitionOrder toPrint, Collection<VirtualPrinter> printers, EventContext newContext) {
        super(printers, newContext);
        this.requisitionToPrint = toPrint;
    }

    @Override
    protected String getDocketType() {
        return DocketTemplate.DocketType.STOCK_REQ_TEMPLATE.toString();
    }

    @Override
    protected DocketTemplate getTemplate() {
        return DocketTemplate.getHighestTemplate(DocketTemplate.DocketType.STOCK_REQ_TEMPLATE, new TriggerActivationContext(this.getContext()));
    }

    @Override
    public String toString() {
        return DocketTemplate.DocketType.STOCK_REQ_TEMPLATE + "";
    }

    @Override
    protected void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        XmlDocket xmlDocket = GroovyDocket.getStockRequisitionDocket();
        xmlDocket.setParams(Arrays.asList(this.requisitionToPrint, this.requisitionToPrint.getRequisitions()));
        xmlDocket.setTemplate(this.getTemplate());
        String xml = xmlDocket.generateXml();
        SimpleDocket docket = new SimpleDocket(printer, xml, this.toString(), DocketTemplate.DocketType.STOCK_REQ_TEMPLATE + "", 0);
        router.printDocket(docket);
    }
}

