/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.finance.reports.RestaurantTakingsSummary;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.docketprocessor.AbstractTerminalPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;

public class TakingsPrintJob
extends AbstractTerminalPrintJob {
    public static final String TAKINGS_DOCKET_TYPE = "TAKINGS";
    private final RestaurantTakingsSummary summary;
    private final List cashdrawerTakings;

    public TakingsPrintJob(RestaurantTakingsSummary restaurantTakings, List newCashdrawTakings, Collection newPrinters, EventContext context) {
        super(newPrinters, context);
        this.summary = restaurantTakings;
        this.cashdrawerTakings = newCashdrawTakings;
    }

    private List getParams() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.summary);
        list.add(this.cashdrawerTakings);
        list.add(this.getTerminal());
        return list;
    }

    @Override
    public void printingDone() {
    }

    @Override
    public String toString() {
        return "Takings docket";
    }

    @Override
    public void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        XmlDocket tDocket = GroovyDocket.getTakingsDocket();
        tDocket.setParams(this.getParams());
        tDocket.setTemplate(this.getTemplate());
        String xml = tDocket.generateXml();
        SalesAccountDocket docket = new SalesAccountDocket(printer, xml, this.toString(), TAKINGS_DOCKET_TYPE);
        router.printDocket(docket);
    }

    @Override
    protected DocketTemplate getTemplate() {
        return DocketTemplate.getHighestTemplate(DocketTemplate.DocketType.TAKINGS_DOCKET, new TriggerActivationContext(this.getContext()));
    }

    @Override
    protected String getDocketType() {
        return DocketTemplate.DocketType.TAKINGS_DOCKET.toString();
    }
}

