/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.sales.Account;
import ordermate.database.users.User;
import ordermate.docketprocessor.PrepPrintJob;

public class TransferPrepPrintJob
extends PrepPrintJob {
    private Account targetAccount;
    private Account sourceAccount;

    TransferPrepPrintJob(Account printAccount, Account newTargetAccount, User user, Terminal printFrom) {
        super(printAccount, new EventContext(printFrom, user));
        this.targetAccount = newTargetAccount;
        this.sourceAccount = printAccount;
    }

    @Override
    protected List getParams(VirtualPrinter printer) {
        boolean usesSeatNums = this.getTerminal().getSeatNums() && this.getAccount().usesSeatNums();
        ArrayList<Serializable> params = new ArrayList<Serializable>();
        params.add(this.getAccount());
        params.add(Boolean.valueOf(usesSeatNums));
        params.add(printer);
        params.add(this.getTerminal());
        params.add(this.getUser());
        params.add(this.targetAccount);
        params.add(new Integer(printer.getDocketNumber() + 1));
        params.add(Boolean.FALSE);
        return params;
    }

    @Override
    protected Account getAccount() {
        return this.sourceAccount;
    }

    public Account getTargetAccount() {
        return this.targetAccount;
    }
}

