/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.docket.SimpleDocket;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.docketprocessor.AbstractPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.dockets.groovy.XmlDocket;

public class VoucherPrintJob
extends AbstractPrintJob {
    private final GiftVoucher voucher;
    private final EventContext context;

    VoucherPrintJob(GiftVoucher voucher, EventContext context) {
        this.voucher = voucher;
        this.context = context;
    }

    @Override
    public Collection<VirtualPrinter> getPrinters() {
        List<VirtualPrinter> printerList = this.context.getTerminal().getAvailableReceiptPrinters();
        if (printerList.size() > 1) {
            VirtualPrinter toPrintFrom = printerList.get(0);
            printerList.clear();
            printerList.add(toPrintFrom);
        }
        return printerList;
    }

    @Override
    public String toString() {
        return "Print Voucher " + this.voucher.getUniqueId();
    }

    protected List<Object> getParams(VirtualPrinter printer) {
        ArrayList<Object> params = new ArrayList<Object>();
        params.add(this.voucher);
        params.add(printer);
        return params;
    }

    @Override
    protected void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        XmlDocket gDocket = GroovyDocket.getVoucherDocket();
        gDocket.setParams(this.getParams(printer));
        gDocket.setTemplate(DocketTemplate.findTemplate(DocketTemplate.DocketType.VOUCHER_DOCKET.getLabel()));
        String xml = gDocket.generateXml();
        SimpleDocket docket = new SimpleDocket(printer, xml, this.toString(), DocketTemplate.DocketType.VOUCHER_DOCKET.getLabel(), 0);
        router.printDocket(docket);
    }

    @Override
    protected void printingDone() {
    }
}

