/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import java.util.Collection;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.docket.SimpleDocket;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.docketprocessor.AbstractTerminalPrintJob;
import ordermate.docketprocessor.DocketRouter;
import ordermate.docketprocessor.GroovyDocket;
import ordermate.docketprocessor.WaitermateReportType;
import ordermate.dockets.groovy.XmlDocket;

public class WaitermateReportPrintJob
extends AbstractTerminalPrintJob {
    private final List<Object> params;
    private final WaitermateReportType reportType;

    public WaitermateReportPrintJob(List<Object> yourParams, Collection<VirtualPrinter> newPrinters, WaitermateReportType reportType, EventContext context) {
        super(newPrinters, context);
        this.reportType = reportType;
        this.params = yourParams;
    }

    private List getParams() {
        return this.params;
    }

    @Override
    public void printingDone() {
    }

    @Override
    public String toString() {
        return this.reportType.getLabel();
    }

    @Override
    public void doPrintDocket(VirtualPrinter printer, DocketRouter router) throws Exception {
        XmlDocket tDocket = GroovyDocket.getDocket(this.reportType.getDocketClass());
        tDocket.setParams(this.getParams());
        tDocket.setTemplate(this.getTemplate());
        String xml = tDocket.generateXml();
        SimpleDocket docket = new SimpleDocket(printer, xml, this.reportType.getLabel(), this.reportType.getLabel(), 0);
        router.printDocket(docket);
    }

    @Override
    protected DocketTemplate getTemplate() {
        return DocketTemplate.getHighestTemplate(DocketTemplate.DocketType.TAKINGS_DOCKET, new TriggerActivationContext(this.getContext()));
    }

    @Override
    protected String getDocketType() {
        return DocketTemplate.DocketType.TAKINGS_DOCKET.toString();
    }
}

