/*
 * Decompiled with CFR 0.152.
 */
package ordermate.docketprocessor;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ordermate.database.EventContext;
import ordermate.database.course.CoursePrintStatus;
import ordermate.database.course.SalesAccountCourse;
import ordermate.database.docket.SalesAccountDocket;
import ordermate.database.hardware.PrinterGroup;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.kts.KTSDocketState;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.printSummary.PrepDocketHelper;
import ordermate.database.workflow.QuantitiesToPrint;
import ordermate.database.workflow.action.WorkflowPrintAction;
import ordermate.docketprocessor.PrepPrintJob;

public class WorkflowPrepPrintJob
extends PrepPrintJob {
    private VirtualPrinter printer;
    private Set<WorkflowPrintAction> printActions;
    private List<SalesItemQuantity> itemQtys;
    private Set<PrinterGroup> groups;
    private final Account targetAccount;
    private Map<VirtualPrinter, Set<QuantitiesToPrint>> notifyPrinterQuantities;

    public WorkflowPrepPrintJob(Account printAccount, EventContext context, VirtualPrinter vPrinter, Set<WorkflowPrintAction> thePrintActions, List<SalesItemQuantity> qtys, Set<PrinterGroup> theGroups) {
        this(printAccount, context, vPrinter, thePrintActions, qtys, theGroups, null, false);
    }

    public WorkflowPrepPrintJob(Account printAccount, EventContext context, VirtualPrinter vPrinter, Set<WorkflowPrintAction> thePrintActions, List<SalesItemQuantity> qtys, Set<PrinterGroup> theGroups, Account targetAccount, boolean prepSum, boolean rushed) {
        super(printAccount, context, prepSum, rushed);
        this.printer = this.refreshPrinter(vPrinter);
        this.printActions = thePrintActions;
        this.groups = theGroups;
        this.itemQtys = qtys;
        this.targetAccount = targetAccount;
        if (this.itemQtys == null) {
            throw new IllegalArgumentException("Cannot print empty quantities");
        }
        if (this.groups == null) {
            throw new IllegalArgumentException("Cannot selectively print with no printer groups");
        }
    }

    private VirtualPrinter refreshPrinter(VirtualPrinter cachedPrinter) {
        if (cachedPrinter == null) {
            return cachedPrinter;
        }
        return PersistenceManager.getObject(VirtualPrinter.class, Query.select(VirtualPrinter.class).equals(VirtualPrinter.Properties.ID, cachedPrinter.getID()).toString());
    }

    public WorkflowPrepPrintJob(Account printAccount, EventContext context, VirtualPrinter vPrinter, Set<WorkflowPrintAction> thePrintActions, List<SalesItemQuantity> qtys, Set<PrinterGroup> theGroups, Account targetAccount, boolean rushed) {
        this(printAccount, context, vPrinter, thePrintActions, qtys, theGroups, targetAccount, true, rushed);
    }

    @Override
    protected List<SalesItem> getItemsToPrint(PrepDocketHelper helper) {
        ArrayList<SalesItem> toPrint = new ArrayList<SalesItem>();
        for (SalesItemQuantity qty : this.itemQtys) {
            for (SalesItem item : qty.getSalesLineItem().getSalesItems()) {
                PrinterGroup pg;
                if (this.isOnCourseHold(item) || !this.groups.contains(pg = item.getFirstInventoryItem().getPrinterGroup())) continue;
                toPrint.add(item);
            }
        }
        return toPrint;
    }

    private boolean isOnCourseHold(SalesItem item) {
        SalesAccountCourse salesAccountCourse;
        return this.getAccount() instanceof TableAccount && (salesAccountCourse = ((TableAccount)this.getAccount()).getSalesAccountCourse(item.getCourse())) != null && salesAccountCourse.getCoursePrintStatus() == CoursePrintStatus.HOLD;
    }

    @Override
    protected Collection<VirtualPrinter> determinePrintersForItems(List<SalesItem> itemsToPrint, Terminal terminal) {
        Collection<VirtualPrinter> printers = super.determinePrintersForItems(itemsToPrint, terminal);
        if (this.printer != null) {
            printers = printers.contains(this.printer) ? Collections.singleton(this.printer) : Collections.emptyList();
        }
        return printers;
    }

    @Override
    protected SalesAccountDocket createSalesDocket(VirtualPrinter printer, String xml) {
        SalesAccountDocket docket = super.createSalesDocket(printer, xml);
        docket.setInitialState(this.determineDocketState());
        docket.save();
        if (this.printActions != null) {
            for (WorkflowPrintAction action : this.printActions) {
                if (printer.equals(action.getVirtualPrinter())) {
                    action.setDocket(docket);
                    action.saveChild();
                }
                if (docket.getInitialTime() != 0 || action.getActionSet() == null || action.getActionSet().getWorkflow() == null) continue;
                docket.setInitialTime((int)(System.currentTimeMillis() - action.getActionSet().getWorkflow().getDateCreated().getTime()));
            }
        }
        return docket;
    }

    private KTSDocketState determineDocketState() {
        KTSDocketState state = null;
        if (this.printActions != null) {
            for (WorkflowPrintAction action : this.printActions) {
                if (action.getVirtualPrinter() == null || !action.getVirtualPrinter().equals(this.printer) || action.getKtsState() == null || state != null && action.getKtsState().compareTo(state) >= 0) continue;
                state = action.getKtsState();
            }
        }
        return state;
    }

    @Override
    protected List getParams(VirtualPrinter printer) {
        List params = super.getParams(printer);
        params.set(8, this.itemQtys);
        params.set(5, this.targetAccount);
        this.setAdditionalParams(params);
        return params;
    }

    private void setAdditionalParams(List params) {
        HashSet<VirtualPrinter> notifyPrinters = new HashSet<VirtualPrinter>();
        for (SalesItemQuantity quantity : this.itemQtys) {
            Collection<VirtualPrinter> docketPrinters = quantity.getSalesLineItem().getDocketPrinters(this.getTerminal());
            for (VirtualPrinter docketPrinter : docketPrinters) {
                notifyPrinters.addAll(docketPrinter.getNotifyPrinters());
            }
        }
        notifyPrinters.remove(params.get(2));
        params.set(9, notifyPrinters);
        params.set(10, this.notifyPrinterQuantities);
        params.set(11, true);
    }

    Account getTargetAccount() {
        return this.targetAccount;
    }

    @Override
    protected List<SalesItemQuantity> getQuantitiesToPrint() {
        return this.itemQtys;
    }

    public void setNotifyPrinterQuantities(Map<VirtualPrinter, Set<QuantitiesToPrint>> notifyPrinterQuantities) {
        this.notifyPrinterQuantities = notifyPrinterQuantities;
    }
}

