/*
 * Decompiled with CFR 0.152.
 */
package ordermate.dockets.groovy;

import groovy.xml.MarkupBuilder;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ordermate.database.docket.DocketTemplate;
import ordermate.database.docket.TemplateLine;

public class TemplatedBuilder
extends MarkupBuilder {
    private static final String WEIGHT = "weight";
    private static final String COLOR = "color";
    private static final String ALIGN = "align";
    private static final String VISIBLE = "visible";
    private static final String UNDERLINE = "underline";
    private static final String INVERTED = "inverted";
    private static final String REPLACE = "replace";
    private final DocketTemplate template;
    private final Map<String, TemplateLine> templatesNames = new HashMap<String, TemplateLine>();
    private List<TemplateLine> collector = null;

    public TemplatedBuilder(Writer writer, DocketTemplate aTemplate) {
        super(writer);
        this.template = aTemplate;
        if (this.template != null) {
            for (TemplateLine line : this.template.getLines()) {
                this.templatesNames.put(line.getLineName(), line);
            }
        }
    }

    public List getCollector() {
        return this.collector;
    }

    public void setCollector(List list) {
        this.collector = list;
    }

    public DocketTemplate getTemplate() {
        return this.template;
    }

    protected Object createNode(Object name, Map attributes, Object value) {
        this.useTemplate(attributes);
        return super.createNode(name, attributes, value);
    }

    protected Object createNode(Object name, Map attributes) {
        this.useTemplate(attributes);
        return super.createNode(name, attributes);
    }

    private void useTemplate(Map<String, String> attributes) {
        String name = attributes.get("name");
        if (name != null) {
            TemplateLine line = this.templatesNames.get(name);
            if (line != null) {
                if (line.getVisible() != null) {
                    attributes.put(VISIBLE, line.getVisible());
                }
                if (line.getAlign() != null) {
                    attributes.put(ALIGN, line.getAlign());
                }
                if (line.getColor() != null) {
                    attributes.put(COLOR, line.getColor());
                }
                if (line.getWeight() != null) {
                    attributes.put(WEIGHT, line.getWeight());
                }
                if (line.getUnderline() != null) {
                    attributes.put(UNDERLINE, line.getUnderline());
                }
                if (line.getInverted() != null) {
                    attributes.put(INVERTED, line.getInverted());
                }
                if (line.getReplace() != null && line.getReplace().contains("=")) {
                    attributes.put(REPLACE, line.getReplace());
                }
            } else if (this.collector != null) {
                line = new TemplateLine(name);
                String attribute = attributes.get(ALIGN);
                if (attribute != null && !attribute.isEmpty()) {
                    line.setAlign(attribute);
                }
                if ((attribute = attributes.get(COLOR)) != null && !attribute.isEmpty()) {
                    line.setColor(attribute);
                }
                if ((attribute = attributes.get(VISIBLE)) != null && !attribute.isEmpty()) {
                    line.setVisible(attribute);
                }
                if ((attribute = attributes.get(WEIGHT)) != null && !attribute.isEmpty()) {
                    line.setWeight(attribute);
                }
                this.collector.add(line);
            }
        }
    }
}

