/*
 * Decompiled with CFR 0.152.
 */
package ordermate.futureorder;

import au.com.ordermate.glazedlists.PropertyComparator;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.reports.futureorder.FutureOrderPrintExecutable;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.database.users.User;
import ordermate.futureorder.FutureOrderQueries;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class FutureOrderManager {
    private static final FutureOrderManager instance = new FutureOrderManager();
    public final Signal updateOrdersSignal = Signals.createSignal();
    private List<Account> futureOrderedAccounts = new ArrayList<Account>();
    private List<Account> readyToPrint = new ArrayList<Account>();

    public static FutureOrderManager getInstance() {
        return instance;
    }

    private FutureOrderManager() {
        this.updateOrdersSignal.connect(this, "updateOrders");
    }

    public boolean checkInterceptPrintConditions(Account account) {
        return account.getPrepPrintDue() != null && !account.getPrepPrintDue().before(this.getCurrentTime()) && !this.checkPrintAttempt(account);
    }

    private boolean checkPrintAttempt(Account account) {
        return this.readyToPrint.contains(account);
    }

    public boolean orderReadyToPrint() {
        return !this.allAccountsReadyToPrint().isEmpty();
    }

    public void attemptToPrint() {
        this.readyToPrint = this.allAccountsReadyToPrint();
        for (Account acc : this.readyToPrint) {
            this.printAccount(acc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void printAccount(Account acc) {
        if (acc.lock(User.getSystemUser())) {
            try {
                for (SalesLineItem item : acc.getItems()) {
                    for (SalesItemQuantity siq : item.getSalesItemQuantities()) {
                        siq.markAsNotPrinted();
                    }
                }
                acc.printPrepDockets(Terminal.getServerMateTerminal());
                acc.clearPrepPrintDue();
                acc.save();
            }
            catch (Exception e) {
                OrderMate.LOG.error("FutureOrderManager.printAccount() failed to print. ", (Throwable)e);
            }
            finally {
                acc.unlock();
            }
        } else {
            OrderMate.LOG.warn("Attempted to print :" + acc + "\nBut was locked!");
        }
    }

    public void updateOrders() {
        this.futureOrderedAccounts = FutureOrderQueries.getFutureOrdersAwaitingPrepPrinting();
        Collections.sort(this.futureOrderedAccounts, new PropertyComparator(Account.Properties.TIME_DUE));
    }

    List<Account> allAccountsReadyToPrint() {
        this.updateOrders();
        ArrayList<Account> toReturn = new ArrayList<Account>();
        for (Account acc : this.futureOrderedAccounts) {
            if (!this.checkTimeDueForAccount(acc)) continue;
            toReturn.add(acc);
        }
        return toReturn;
    }

    boolean checkTimeDueForAccount(Account acc) {
        return acc.getPrepPrintDue() == null ? false : this.getCurrentTime().after(acc.getPrepPrintDue());
    }

    Date getCurrentTime() {
        return Calendar.getInstance().getTime();
    }

    public OpenOrdersReportPrintTask createPrintTask(AccountSearcher searcher, VirtualPrinter virPrint) {
        return new OpenOrdersReportPrintTask(searcher.search(), virPrint, (Date)searcher.getDateDueRangeSearch().getStart(), (Date)searcher.getDateDueRangeSearch().getEnd());
    }

    private static class OpenOrdersReportPrintTask
    extends AbstractTask {
        private final List<Account> search;
        private final VirtualPrinter byID;
        private final Date start;
        private final Date end;

        public OpenOrdersReportPrintTask(List<Account> search, VirtualPrinter byID, Date start, Date end) {
            this.search = search;
            this.byID = byID;
            this.start = start;
            this.end = end;
        }

        @Override
        public String getName() {
            return "Print Open Orders Report";
        }

        @Override
        protected void performTask() throws Exception {
            boolean successful = PersistenceManager.getServerConnection().runSync(new FutureOrderPrintExecutable(this.search, this.byID, this.start, this.end));
            if (successful) {
                // empty if block
            }
        }

        @Override
        protected int getTotalSubTasks() {
            return 1;
        }
    }
}

