/*
 * Decompiled with CFR 0.152.
 */
package ordermate.futureorder;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;

public class FutureOrderQueries {
    public static List<Account> getFutureOrdersAwaitingPrepPrinting() {
        ObjectQuery openAccountQuery = Query.select(Account.class).equals(Account.Properties.ACCOUNT_STATE, "OPEN").not().isNull(Account.Properties.PREP_PRINT_DUE);
        List<Account> futurePrintAccount = PersistenceManager.getObjectList(Account.class, openAccountQuery.toString(), null);
        Date today = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        calendar.add(6, -7);
        Date sevenDaysAgo = calendar.getTime();
        calendar.setTime(today);
        calendar.add(6, 2);
        Date twoDaysLater = calendar.getTime();
        ObjectQuery closedAccountQuery = Query.select(Account.class).linkUsing(Account.Properties.TRADING_DAY).not().isNull(Account.Properties.PREP_PRINT_DUE).equals(Account.Properties.ACCOUNT_STATE, "CLOSED").wherePropertyBetween(TradingDay.Properties.DATE, sevenDaysAgo, twoDaysLater, SQLDateType.DATE);
        List<Account> closedAccount = PersistenceManager.getObjectList(Account.class, closedAccountQuery.toString(), null);
        if (closedAccount != null && closedAccount.size() != 0) {
            futurePrintAccount.addAll(closedAccount);
        }
        return futurePrintAccount;
    }

    public static String getAllAccountsWithADueDateQuery(AccountType[] types) {
        ObjectQuery query = Query.select(Account.class).whereIn("account_type", Arrays.asList(types)).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).not().isNull(Account.Properties.DATE_DUE);
        return query.toString();
    }

    public static String getAllAccountsWithADueDateQuery(List<AccountType> types) {
        ObjectQuery query = Query.select(Account.class).whereIn("account_type", types).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).not().isNull(Account.Properties.DATE_DUE);
        return query.toString();
    }
}

