/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.SaveContext;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.stock.StockControlProperty;
import ordermate.integrity.TradingDayFinanceChangesExecutable;
import ordermate.integrity.account.AccountLinkSaverExecutable;
import ordermate.integrity.account.NukeAccountExecutable;

public abstract class AbstractSaveAccount {
    private GuiHandler saveAccountGui;

    protected AbstractSaveAccount(GuiHandler gui) {
        this.saveAccountGui = gui;
    }

    protected GuiHandler getGui() {
        return this.saveAccountGui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set doSaveAccounts(final List accounts, final String stockUse, final EventContext eContext) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Must not be called from event dispatch");
        }
        final HashSet returnVal = new HashSet();
        StockControlProperty props = StockControlProperty.getInstance();
        boolean isWastageCheckNeeded = false;
        if (props.isStockControlEnabled() || props.isStockCountDownEnabled()) {
            Iterator it = accounts.iterator();
            while (it.hasNext() && !isWastageCheckNeeded) {
                Account acc = (Account)it.next();
                isWastageCheckNeeded = acc.isWastageCheckNeeded();
            }
        }
        final boolean wastageNeeded = isWastageCheckNeeded;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String stockUsage = stockUse;
                    String stockUsageReason = null;
                    boolean wastage = false;
                    if (wastageNeeded && AbstractSaveAccount.this.saveAccountGui.displayForcedChoiceDialog("Wastage?", "One or more items were removed. Were the ingredients wasted?", "Yes", "No")) {
                        wastage = true;
                        stockUsage = "WASTED";
                        stockUsageReason = ((Account)accounts.get(0)).hasUnsavedRefundedItems() ? "Items refunded in Waitermate." : "Items deleted in WaiterMate. ";
                    }
                    Set set = returnVal;
                    synchronized (set) {
                        Object result = PersistenceManager.getServerConnection().runSync(new AccountLinkSaverExecutable(wastage, accounts, stockUsageReason, stockUsage, eContext));
                        if (result instanceof Set) {
                            returnVal.addAll((Set)result);
                        } else if (result instanceof Exception) {
                            OrderMate.LOG.error("AccountListSaverExecutable encountered an error while allocating accounts to training mode: ", (Throwable)((Exception)result));
                        }
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            OrderMate.LOG.error("InterruptedException caught from doSaveAccounts: ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            OrderMate.LOG.error("InvocationTargetException caught from doSaveAccounts: ", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        HashSet hashSet = returnVal;
        synchronized (hashSet) {
            return returnVal;
        }
    }

    protected void doSaveAccount(Account toSave, String stockUsage, EventContext eContext) {
        boolean wastageNeeded;
        String theUsage = stockUsage;
        String stockUsageReason = null;
        StockControlProperty props = StockControlProperty.getInstance();
        if (toSave.isWastageCheckNeeded() && (props.isStockControlEnabled() || props.isStockCountDownEnabled()) && (wastageNeeded = this.saveAccountGui.displayForcedChoiceDialog("Wastage?", "One or more items were removed. Were the ingredients wasted?", "Yes", "No"))) {
            theUsage = "WASTED";
            stockUsageReason = toSave.hasUnsavedRefundedItems() ? "Items refunded in Waitermate." : "Items deleted in WaiterMate. ";
            for (SalesLineItem item : toSave.getAllItems()) {
                item.markAsWasted();
            }
        }
        if (!toSave.isSaveAllowed()) {
            if (Config.isDebuging()) {
                OrderMate.LOG.warn("Try to avoid to save an empty acount!", (Throwable)new Exception());
            } else {
                OrderMate.LOG.warn("Try to avoid to save an empty acount!");
            }
            return;
        }
        SaveContext context = toSave.createSaveContext(stockUsageReason, theUsage, eContext.getTerminal());
        toSave.prepareForSave(context);
        toSave.save();
    }

    public synchronized boolean assignToTraining(final List<Account> accounts, final EventContext context, final JDialog progressDialog, final Refreshable refreshable) {
        boolean doContinue;
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Should be EDT");
        }
        boolean hasCustomer = false;
        final HashSet<Long> allTradingDayIDs = new HashSet<Long>();
        StringBuilder nonDeletableAccountsIDs = new StringBuilder();
        ArrayList<Account> nonDeletable = new ArrayList<Account>();
        for (Account acc : accounts) {
            List<GiftVoucherTransaction> voucherTxns;
            if (!hasCustomer) {
                hasCustomer = acc.hasCustomer();
            }
            if ((voucherTxns = acc.getVoucherTxns()) != null && voucherTxns.size() > 0) {
                nonDeletableAccountsIDs.append(acc.getID().toString()).append(",");
                nonDeletable.add(acc);
            }
            allTradingDayIDs.add(acc.getTradingDay().getID());
        }
        accounts.removeAll(nonDeletable);
        boolean bl = doContinue = !accounts.isEmpty();
        if (hasCustomer) {
            doContinue = this.saveAccountGui.displayForcedChoiceDialog("Customer Account Selected", "<html>You have selected an account with a customer.<br>If you choose to continue the customer's history will be affected.</html>", "Ok", "Cancel");
        }
        if (doContinue) {
            doContinue = this.saveAccountGui.displayForcedChoiceDialog("Allocate to Training", "<html>If you allocate these accounts to training mode they<br>will be permanently deleted and cannot be undone.<br><br>Are you sure you  want to continue?", "Ok", "Cancel");
            String nonDeletableIdsStr = nonDeletableAccountsIDs.toString();
            if (doContinue && !nonDeletableIdsStr.isEmpty()) {
                doContinue = this.saveAccountGui.displayForcedChoiceDialog("Allocate to Training", "<html>Accounts with the following IDs will not be deleted,<br>as they contain voucher transactions.<br>" + nonDeletableIdsStr.substring(0, nonDeletableIdsStr.length() - 1) + "<br><br>Are you sure you  want to continue?", "Ok", "Cancel");
            }
        }
        if (doContinue) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    for (Account acc : accounts) {
                        acc.lock(context.getUser());
                        acc.removeAllItems(context);
                    }
                    Set idSet = AbstractSaveAccount.this.doSaveAccounts(accounts, "NORMAL", context);
                    accounts.clear();
                    Object result = PersistenceManager.getServerConnection().runSync(new NukeAccountExecutable(idSet, context.getUser()));
                    if (result != null) {
                        OrderMate.LOG.error("NukeAccountExecutable encountered an error while allocating accounts to training mode: ", (Throwable)((Exception)result));
                        AbstractSaveAccount.this.dismissDialogAndRefresh(progressDialog, refreshable);
                        return;
                    }
                    result = PersistenceManager.getServerConnection().runSync(new TradingDayFinanceChangesExecutable(allTradingDayIDs));
                    if (result != null) {
                        OrderMate.LOG.error("TradingDayFinanceChangesExecutable encountered an error while allocating accounts to training mode: ", (Throwable)((Exception)result));
                        AbstractSaveAccount.this.dismissDialogAndRefresh(progressDialog, refreshable);
                        return;
                    }
                    AbstractSaveAccount.this.dismissDialogAndRefresh(progressDialog, refreshable);
                }
            }).start();
        }
        return doContinue;
    }

    private void dismissDialogAndRefresh(final JDialog progressDialog, final Refreshable refreshable) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (progressDialog != null) {
                    progressDialog.dispose();
                }
                if (refreshable != null) {
                    refreshable.refresh();
                }
            }
        });
    }
}

