/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import au.com.ordermate.gui.adminkit.ComponentColors;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AutoCompletion
extends PlainDocument {
    JComboBox comboBox;
    ComboBoxModel model;
    JTextField editor;
    boolean selecting = false;
    boolean hidePopupOnFocusLoss;
    boolean hitBackspace = false;
    boolean hitBackspaceOnSelection;
    KeyListener editorKeyListener;
    FocusListener editorFocusListener;

    public AutoCompletion(JComboBox theComboBox) {
        this.comboBox = theComboBox;
        this.model = this.comboBox.getModel();
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AutoCompletion.this.selecting) {
                    AutoCompletion.this.highlightCompletedText(0);
                }
            }
        });
        this.comboBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("editor")) {
                    AutoCompletion.this.configureEditor((ComboBoxEditor)e.getNewValue());
                }
                if (e.getPropertyName().equals("model")) {
                    AutoCompletion.this.model = (ComboBoxModel)e.getNewValue();
                }
            }
        });
        this.editorKeyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (AutoCompletion.this.comboBox.isDisplayable()) {
                    AutoCompletion.this.comboBox.setPopupVisible(true);
                }
                AutoCompletion.this.hitBackspace = false;
                switch (e.getKeyCode()) {
                    case 8: {
                        AutoCompletion.this.hitBackspace = true;
                        AutoCompletion.this.hitBackspaceOnSelection = AutoCompletion.this.editor.getSelectionStart() != AutoCompletion.this.editor.getSelectionEnd();
                        break;
                    }
                    case 127: {
                        e.consume();
                        AutoCompletion.this.comboBox.getToolkit().beep();
                    }
                }
            }
        };
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editorFocusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                AutoCompletion.this.highlightCompletedText(0);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (AutoCompletion.this.hidePopupOnFocusLoss) {
                    AutoCompletion.this.comboBox.setPopupVisible(false);
                }
            }
        };
        this.configureEditor(this.comboBox.getEditor());
        Object selected = this.comboBox.getSelectedItem();
        if (selected != null) {
            this.setText(selected.toString());
        }
        this.highlightCompletedText(0);
    }

    JList getListBox() {
        JList listBox;
        try {
            Field field = JComponent.class.getDeclaredField("ui");
            field.setAccessible(true);
            BasicComboBoxUI ui = (BasicComboBoxUI)field.get(this.comboBox);
            field = BasicComboBoxUI.class.getDeclaredField("listBox");
            field.setAccessible(true);
            listBox = (JList)field.get(ui);
        }
        catch (NoSuchFieldException nsfe) {
            throw new RuntimeException(nsfe);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        return listBox;
    }

    public static void enable(JComboBox comboBox) {
        comboBox.setEditable(true);
        new AutoCompletion(comboBox);
    }

    void configureEditor(ComboBoxEditor newEditor) {
        if (this.editor != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
            this.editor.removeFocusListener(this.editorFocusListener);
        }
        if (newEditor != null) {
            this.editor = (JTextField)newEditor.getEditorComponent();
            this.editor.setBackground(ComponentColors.COMBO_BOX_EDITOR_COLOR);
            this.editor.setColumns(15);
            this.editor.addKeyListener(this.editorKeyListener);
            this.editor.addFocusListener(this.editorFocusListener);
            this.editor.setDocument(this);
        }
    }

    @Override
    public void remove(int offset, int len) throws BadLocationException {
        int offs = offset;
        if (this.selecting) {
            return;
        }
        if (this.hitBackspace) {
            if (offs > 0) {
                if (this.hitBackspaceOnSelection) {
                    --offs;
                }
            } else {
                UIManager.getLookAndFeel().provideErrorFeedback(this.comboBox);
            }
            this.highlightCompletedText(offs);
        } else {
            super.remove(offs, len);
        }
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        int offs = offset;
        if (this.selecting) {
            return;
        }
        super.insertString(offs, str, a);
        Object item = this.lookupItem(this.getText(0, this.getLength()));
        if (item != null) {
            this.setSelectedItem(item);
        } else {
            item = this.comboBox.getSelectedItem();
            offs -= str.length();
            this.comboBox.getToolkit().beep();
        }
        if (item != null) {
            this.setText(item.toString());
        }
        this.highlightCompletedText(offs + str.length());
    }

    private void setText(String text) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void highlightCompletedText(int start) {
        this.editor.setCaretPosition(this.getLength());
        this.editor.moveCaretPosition(start);
    }

    private void setSelectedItem(Object item) {
        this.selecting = true;
        this.model.setSelectedItem(item);
        this.selecting = false;
    }

    private Object lookupItem(String pattern) {
        Object selectedItem = this.model.getSelectedItem();
        if (selectedItem != null && this.startsWithIgnoreCase(selectedItem.toString(), pattern)) {
            return selectedItem;
        }
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object currentItem = this.model.getElementAt(i);
            if (currentItem == null || !this.startsWithIgnoreCase(currentItem.toString(), pattern)) continue;
            return currentItem;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String str1, String str2) {
        return str1.toUpperCase().startsWith(str2.toUpperCase());
    }
}

