/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import com.jgoodies.forms.factories.Borders;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class BorderUtils {
    public static void addEmptyBorder(JComponent toAddBorderTo) {
        Border currentBorder = BorderUtils.findCurrentBorder(toAddBorderTo);
        if (currentBorder == null) {
            toAddBorderTo.setBorder(new BorderUtilsEmptyBorder());
        } else if (!(currentBorder instanceof BorderUtilsEmptyBorder)) {
            CompoundBorder compound = new CompoundBorder(new BorderUtilsEmptyBorder(), currentBorder);
            toAddBorderTo.setBorder(compound);
        }
    }

    private static Border findCurrentBorder(JComponent toFind) {
        Border current = toFind.getBorder();
        while (current instanceof CompoundBorder) {
            current = ((CompoundBorder)current).getOutsideBorder();
        }
        return current;
    }

    private static class BorderUtilsEmptyBorder
    implements Border {
        private Border delegate = Borders.DIALOG_BORDER;

        @Override
        public Insets getBorderInsets(Component c) {
            return this.delegate.getBorderInsets(c);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.delegate.isBorderOpaque();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.delegate.paintBorder(c, g, x, y, width, height);
        }
    }
}

