/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class CaptureKeyboard
implements KeyEventDispatcher {
    public final Signal<KeyEvent, ?, ?, ?, ?> keyPressed = Signals.createSignal(KeyEvent.class, "keyEvent");
    private static CaptureKeyboard keyboard;
    private boolean processEvents = true;

    private CaptureKeyboard() {
    }

    public void processEvents(boolean value) {
        this.processEvents = value;
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (!this.processEvents) {
            return false;
        }
        boolean consumeKeyEvent = true;
        if (e.getID() == 401) {
            if (KeyEvent.getKeyText(e.getKeyCode()).equalsIgnoreCase("Enter") || KeyEvent.getKeyText(e.getKeyCode()).equalsIgnoreCase("Space")) {
                this.keyPressed.emit(e);
            }
        } else if (e.getID() == 400) {
            if (e.getKeyChar() != '\n') {
                this.keyPressed.emit(e);
            }
        } else {
            consumeKeyEvent = false;
        }
        return consumeKeyEvent;
    }

    public static boolean isActive() {
        return keyboard != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CaptureKeyboard getInstance() {
        if (keyboard != null) return keyboard;
        Class<CaptureKeyboard> clazz = CaptureKeyboard.class;
        synchronized (CaptureKeyboard.class) {
            keyboard = new CaptureKeyboard();
            KeyboardFocusManager kfm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            kfm.addKeyEventDispatcher(keyboard);
            // ** MonitorExit[var0] (shouldn't be in output)
            return keyboard;
        }
    }
}

