/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.AbstractButton;
import javax.swing.border.Border;
import ordermate.gui.ButtonStyler;
import ordermate.gui.OrderMateThemeI;
import ordermate.gui.themes.OrderMateTheme;

public class DefaultButtonStyler
implements ButtonStyler {
    private Border buttonBorder;
    private Font buttonFont;
    private Dimension buttonSize;
    private Color foregroundColor;
    private boolean transparentButton = false;

    @Override
    public void styleButton(AbstractButton button) {
        OrderMateThemeI.Helper.setupKeypadButton(button);
        if (this.transparentButton) {
            OrderMateTheme.setupTransparentButton(button);
        }
        if (this.buttonBorder != null) {
            button.setBorderPainted(true);
            button.setBorder(this.buttonBorder);
        }
        if (this.foregroundColor != null) {
            button.setForeground(this.foregroundColor);
        }
        if (this.buttonFont != null) {
            button.setFont(this.buttonFont);
        }
        if (this.buttonSize != null) {
            button.setPreferredSize(this.buttonSize);
            button.setSize(this.buttonSize);
        }
    }

    public void setButtonBorder(Border border) {
        this.buttonBorder = border;
    }

    public void setButtonFont(Font value) {
        this.buttonFont = value;
    }

    public void setButtonSize(Dimension value) {
        this.buttonSize = value;
    }

    public void setTransparentButton(boolean value) {
        this.transparentButton = value;
    }

    public void setButtonForeground(Color value) {
        this.foregroundColor = value;
    }
}

