/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import java.awt.event.KeyEvent;
import ordermate.gui.InputAdapter;
import ordermate.gui.LostKeyEventSlot;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class DefaultLostKeyListener
extends LostKeyEventSlot {
    public Signal<?, ?, ?, ?, ?> gotDelete = Signals.createSignal();
    public Signal<?, ?, ?, ?, ?> gotClear = Signals.createSignal();
    public Signal<String, ?, ?, ?, ?> gotCharacter = Signals.createSignal(String.class, "character");
    public Signal<?, ?, ?, ?, ?> gotEnter = Signals.createSignal();
    public Signal<Boolean, ?, ?, ?, ?> gotTab = Signals.createSignal(Boolean.class, "isBackward");

    public DefaultLostKeyListener(InputAdapter inputAdapter) {
        super(inputAdapter);
    }

    @Override
    public void onLostEvent(KeyEvent e) {
        char keyChar = e.getKeyChar();
        if (keyChar == '\b' || keyChar == '\u007f') {
            this.gotDelete.emit();
        } else if (keyChar == '\u001b') {
            this.gotClear.emit();
        } else if (keyChar == '\n') {
            this.gotEnter.emit();
        } else if (Character.isLetterOrDigit(keyChar) || keyChar == ' ' || keyChar == '_' || keyChar == '-' || keyChar == '@' || keyChar == '/' || keyChar == '\\' || keyChar == ',' || keyChar == '.' || keyChar == '~' || keyChar == ';') {
            this.gotCharacter.emit(Character.toString(keyChar));
        } else if (keyChar == '\t') {
            this.gotTab.emit(e.isShiftDown());
        }
    }
}

