/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class DefaultTextField
extends JTextField {
    final Dimension TEXTFIELD_SIZE = new Dimension(250, 20);
    private String defaultText;

    public DefaultTextField(String currentValue, String theDefaultText) {
        this.defaultText = theDefaultText;
        if (currentValue != null) {
            this.setText(currentValue);
        } else {
            this.setText(theDefaultText);
            this.setDefaultTextStyle();
        }
        this.setPreferredSize(this.TEXTFIELD_SIZE);
        this.addFocusListener(new TextFieldFocusListener());
    }

    public DefaultTextField(String currentValue) {
        this(currentValue, null);
    }

    public void setNormalTextStyle() {
        this.setForeground(Color.BLACK);
    }

    public void setDefaultTextStyle() {
        this.setForeground(Color.GRAY);
    }

    @Override
    public String getText() {
        String text = super.getText();
        if (text.equals(this.defaultText)) {
            return null;
        }
        return text.trim();
    }

    private class TextFieldFocusListener
    implements FocusListener {
        private TextFieldFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (DefaultTextField.this.getText() == null) {
                DefaultTextField.this.setText(null);
            }
            DefaultTextField.this.setNormalTextStyle();
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (DefaultTextField.this.getText() == null || DefaultTextField.this.getText().length() == 0) {
                DefaultTextField.this.setText(DefaultTextField.this.defaultText);
                DefaultTextField.this.setDefaultTextStyle();
            } else {
                DefaultTextField.this.setNormalTextStyle();
            }
        }
    }
}

