/*
 * Decompiled with CFR 0.152.
 */
package ordermate.gui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class FieldPanelBuilder {
    private int pxBetweenCols = 4;
    private int pxBetweenRows = 4;
    private int numRows;
    private FormLayout layout;
    private PanelBuilder builder;
    private CellConstraints cc;

    public FieldPanelBuilder() {
        this.clear();
    }

    public FieldPanelBuilder(JPanel panel) {
        this.clear(panel);
    }

    public FieldPanelBuilder(int pixelsBetweenRows) {
        this.pxBetweenRows = pixelsBetweenRows;
        this.clear();
    }

    public FieldPanelBuilder(int pixelsBetweenRows, int pixelsBetweenCols) {
        this.pxBetweenRows = pixelsBetweenRows;
        this.pxBetweenCols = pixelsBetweenCols;
        this.clear();
    }

    public void clear() {
        this.clear(null);
    }

    public void clear(JPanel panel) {
        this.numRows = 0;
        this.layout = this.constructFormLayout();
        this.builder = panel == null ? new PanelBuilder(this.layout) : new PanelBuilder(this.layout, panel);
        this.builder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.cc = new CellConstraints();
    }

    public FieldPanelBuilder addRow(String text, Component comp) {
        return this.addRow(text, comp, null);
    }

    public void addSeparator(String title) {
        this.layout.appendRow(new RowSpec("pref"));
        this.layout.appendRow(new RowSpec(this.pxBetweenRows + "px"));
        this.builder.addSeparator(title, this.cc.xywh(1, this.numRows * 2 + 1, 3, 1));
        ++this.numRows;
    }

    public FieldPanelBuilder addRow(String text, Component comp, String toolTip) {
        this.layout.appendRow(new RowSpec("pref"));
        this.layout.appendRow(new RowSpec(this.pxBetweenRows + "px"));
        JLabel label = new JLabel(text);
        label.setHorizontalAlignment(4);
        label.setToolTipText(toolTip);
        if (comp instanceof JComponent) {
            ((JComponent)comp).setToolTipText(toolTip);
        }
        label.setLabelFor(comp);
        this.builder.add((Component)label, this.cc.xy(1, this.numRows * 2 + 1));
        this.builder.add(comp, this.cc.xy(3, this.numRows * 2 + 1));
        ++this.numRows;
        return this;
    }

    public FieldPanelBuilder addRow(Component comp) {
        this.layout.appendRow(new RowSpec("pref"));
        this.layout.appendRow(new RowSpec(this.pxBetweenRows + "px"));
        this.builder.add(comp, this.cc.xywh(1, this.numRows * 2 + 1, 3, 1));
        return this;
    }

    public FieldPanelBuilder addRow(JLabel text, Component comp) {
        return this.addRow(text, comp, null);
    }

    public FieldPanelBuilder addRow(JLabel label, Component comp, String toolTip) {
        this.layout.appendRow(new RowSpec("pref"));
        this.layout.appendRow(new RowSpec(this.pxBetweenRows + "px"));
        label.setHorizontalAlignment(4);
        label.setToolTipText(toolTip);
        if (comp instanceof JComponent) {
            ((JComponent)comp).setToolTipText(toolTip);
        }
        this.builder.add((Component)label, this.cc.xy(1, this.numRows * 2 + 1));
        this.builder.add(comp, this.cc.xy(3, this.numRows * 2 + 1));
        ++this.numRows;
        return this;
    }

    public JPanel getPanel() {
        return this.builder.getPanel();
    }

    public void setBorder(Border border) {
        this.builder.setBorder(border);
    }

    public FormLayout constructFormLayout() {
        return new FormLayout("right:pref, " + this.pxBetweenCols + "px, left:max(40dlu;pref)");
    }
}

